/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rwstore.RWStore;

public class RWAddressManager
implements IAddressManager {
    RWStore m_store;

    public RWAddressManager(RWStore store) {
        this.m_store = store;
    }

    @Override
    public int getByteCount(long addr) {
        return (int)(addr & 0xFFFFFFFFL);
    }

    @Override
    public long getOffset(long addr) {
        return addr >> 32;
    }

    @Override
    public long getPhysicalAddress(long addr) {
        return this.m_store.physicalAddress((int)this.getOffset(addr));
    }

    @Override
    public long toAddr(int nbytes, long offset) {
        return (offset << 32) + (long)nbytes;
    }

    @Override
    public String toString(long addr) {
        if (this.m_store == null) {
            return "{off=NATIVE:" + this.getOffset(addr) + ",len=" + this.getByteCount(addr) + "}";
        }
        return "{off=" + this.m_store.physicalAddress((int)this.getOffset(addr)) + ",len=" + this.getByteCount(addr) + "}";
    }
}

