/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree.data;

import com.bigdata.btree.data.AbstractReadOnlyNodeData;
import com.bigdata.btree.data.IAbstractNodeDataCoder;
import com.bigdata.htree.data.IDirectoryData;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DefaultDirectoryPageCoder
implements IAbstractNodeDataCoder<IDirectoryData>,
Externalizable {
    private static final transient byte VERSION0 = 0;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(0);
    }

    @Override
    public final boolean isLeafDataCoder() {
        return false;
    }

    @Override
    public boolean isNodeDataCoder() {
        return true;
    }

    @Override
    public IDirectoryData decode(AbstractFixedByteArrayBuffer data) {
        return new ReadOnlyDirectoryData(data);
    }

    @Override
    public IDirectoryData encodeLive(IDirectoryData node, DataOutputBuffer buf) {
        int nchildren;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        boolean version = true;
        int O_origin = buf.pos();
        buf.putByte((byte)0);
        buf.putShort((short)1);
        boolean hasVersionTimestamps = node.hasVersionTimestamps();
        short flags = 0;
        if (hasVersionTimestamps) {
            flags = (short)(flags | 2);
            throw new UnsupportedOperationException();
        }
        if (node.isOverflowDirectory()) {
            flags = (short)(flags | 8);
        }
        buf.putShort(flags);
        if (node.isOverflowDirectory()) {
            byte[] ok = node.getOverflowKey();
            buf.putShort((short)ok.length);
            buf.put(ok);
        }
        if ((nchildren = node.getChildCount()) > Short.MAX_VALUE) {
            throw new UnsupportedOperationException();
        }
        buf.putShort((short)nchildren);
        for (int i = 0; i < nchildren; ++i) {
            buf.putLong(node.getChildAddr(i));
        }
        AbstractFixedByteArrayBuffer slice = buf.slice(O_origin, buf.pos() - O_origin);
        return new ReadOnlyDirectoryData(slice);
    }

    @Override
    public AbstractFixedByteArrayBuffer encode(IDirectoryData node, DataOutputBuffer buf) {
        return this.encodeLive(node, buf).data();
    }

    public static StringBuilder toString(IDirectoryData node, StringBuilder sb) {
        int nchildren = node.getChildCount();
        sb.append(", nchildren=" + nchildren);
        sb.append(",\nchildAddr=[");
        for (int i = 0; i < nchildren; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(node.getChildAddr(i));
        }
        sb.append("]");
        if (node.hasVersionTimestamps()) {
            sb.append(",\nversionTimestamps={min=" + node.getMinimumVersionTimestamp() + ",max=" + node.getMaximumVersionTimestamp() + "}");
        }
        return sb;
    }

    private static class ReadOnlyDirectoryData
    extends AbstractReadOnlyNodeData<IDirectoryData>
    implements IDirectoryData {
        private final AbstractFixedByteArrayBuffer b;
        private final short version;
        private final short flags;
        private final int nchildren;
        private final byte[] overflowKey;
        private final int O_childAddr;

        @Override
        public final AbstractFixedByteArrayBuffer data() {
            return this.b;
        }

        public ReadOnlyDirectoryData(AbstractFixedByteArrayBuffer buf) {
            if (buf == null) {
                throw new IllegalArgumentException();
            }
            int pos = 0;
            byte type = buf.getByte(pos);
            ++pos;
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new AssertionError();
                }
                case 2: {
                    throw new AssertionError();
                }
                default: {
                    throw new AssertionError((Object)("type=" + type));
                }
            }
            this.version = buf.getShort(pos);
            pos += 2;
            switch (this.version) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("version=" + this.version));
                }
            }
            this.flags = buf.getShort(pos);
            pos += 2;
            if (this.isOverflowDirectory()) {
                short oksze = buf.getShort(pos);
                this.overflowKey = new byte[oksze];
                buf.get(pos += 2, this.overflowKey);
                pos += oksze;
            } else {
                this.overflowKey = null;
            }
            this.nchildren = buf.getShort(pos);
            this.O_childAddr = pos += 2;
            this.b = buf;
        }

        @Override
        public final boolean hasVersionTimestamps() {
            return (this.flags & 2) != 0;
        }

        @Override
        public final long getMinimumVersionTimestamp() {
            if (!this.hasVersionTimestamps()) {
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final long getMaximumVersionTimestamp() {
            if (!this.hasVersionTimestamps()) {
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isOverflowDirectory() {
            return (this.flags & 8) != 0;
        }

        @Override
        public final boolean isLeaf() {
            return false;
        }

        @Override
        public final boolean isReadOnly() {
            return true;
        }

        @Override
        public final boolean isCoded() {
            return true;
        }

        @Override
        public final int getChildCount() {
            return this.nchildren;
        }

        protected boolean assertChildIndex(int index) {
            if (index < 0 || index > this.nchildren) {
                throw new IndexOutOfBoundsException("index=" + index + ", nchildren=" + this.nchildren);
            }
            return true;
        }

        @Override
        public final long getChildAddr(int index) {
            assert (this.assertChildIndex(index));
            return this.b.getLong(this.O_childAddr + index * 8);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName() + "{");
            DefaultDirectoryPageCoder.toString(this, sb);
            sb.append("}");
            return sb.toString();
        }

        @Override
        public byte[] getOverflowKey() {
            return this.overflowKey;
        }
    }
}

