/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.AsynchronousIndexWriteConfiguration;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BloomFilterFactory;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.HTreeIndexMetadata;
import com.bigdata.btree.IOverflowHandler;
import com.bigdata.btree.ISimpleSplitHandler;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.ScatterSplitConfiguration;
import com.bigdata.btree.isolation.IConflictResolver;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.raba.codec.CanonicalHuffmanRabaCoder;
import com.bigdata.btree.raba.codec.FrontCodedRabaCoder;
import com.bigdata.btree.raba.codec.FrontCodedRabaCoderDupKeys;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.config.Configuration;
import com.bigdata.config.IValidator;
import com.bigdata.config.IntegerRangeValidator;
import com.bigdata.config.IntegerValidator;
import com.bigdata.io.LongPacker;
import com.bigdata.io.SerializerUtil;
import com.bigdata.io.compression.IRecordCompressorFactory;
import com.bigdata.journal.IIndexManager;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IDataService;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class IndexMetadata
implements Serializable,
Externalizable,
Cloneable,
IKeyBuilderFactory {
    private static final long serialVersionUID = 4370669592664382720L;
    private static final transient Logger log = Logger.getLogger(IndexMetadata.class);
    private transient long addrMetadata;
    private transient UUID initialDataServiceUUID;
    private UUID indexUUID;
    private String name;
    private IndexTypeEnum indexType;
    private int branchingFactor;
    private int writeRetentionQueueCapacity;
    private int writeRetentionQueueScan;
    private LocalPartitionMetadata pmd;
    private String btreeClassName;
    private String checkpointClassName;
    private IRabaCoder nodeKeysCoder;
    private ITupleSerializer<?, ?> tupleSer;
    private IRecordCompressorFactory<?> btreeRecordCompressorFactory;
    private IRecordCompressorFactory<?> indexSegmentRecordCompressorFactory;
    private IConflictResolver conflictResolver;
    private boolean deleteMarkers;
    private boolean versionTimestamps;
    private boolean versionTimestampFilters;
    private boolean rawRecords;
    private short maxRecLen;
    private BloomFilterFactory bloomFilterFactory;
    private IOverflowHandler overflowHandler;
    private ISimpleSplitHandler splitHandler2;
    private AsynchronousIndexWriteConfiguration asynchronousIndexWriteConfiguration;
    private ScatterSplitConfiguration scatterSplitConfiguration;
    private int indexSegmentBranchingFactor;
    private boolean indexSegmentBufferNodes;
    private static final transient int VERSION0 = 0;
    private static final transient int VERSION1 = 1;
    private static final transient int VERSION2 = 2;
    private static final transient int VERSION3 = 3;
    private static final transient int VERSION4 = 4;
    private static final transient int CURRENT_VERSION = 4;
    private transient int version;

    public final long getMetadataAddr() {
        return this.addrMetadata;
    }

    public UUID getInitialDataServiceUUID() {
        return this.initialDataServiceUUID;
    }

    public void setInitialDataServiceUUID(UUID uuid) {
        this.initialDataServiceUUID = uuid;
    }

    public final UUID getIndexUUID() {
        return this.indexUUID;
    }

    public final IndexTypeEnum getIndexType() {
        return this.indexType;
    }

    public final String getName() {
        return this.name;
    }

    public final int getBranchingFactor() {
        return this.branchingFactor;
    }

    public final int getIndexSegmentBranchingFactor() {
        return this.indexSegmentBranchingFactor;
    }

    public final boolean getIndexSegmentBufferNodes() {
        return this.indexSegmentBufferNodes;
    }

    public final void setIndexSegmentBufferNodes(boolean newValue) {
        this.indexSegmentBufferNodes = newValue;
    }

    public IRecordCompressorFactory getBtreeRecordCompressorFactory() {
        return this.btreeRecordCompressorFactory;
    }

    public void setBtreeRecordCompressorFactory(IRecordCompressorFactory btreeRecordCompressorFactory) {
        this.btreeRecordCompressorFactory = btreeRecordCompressorFactory;
    }

    public IRecordCompressorFactory getIndexSegmentRecordCompressorFactory() {
        return this.indexSegmentRecordCompressorFactory;
    }

    public void setIndexSegmentRecordCompressorFactory(IRecordCompressorFactory segmentRecordCompressorFactory) {
        this.indexSegmentRecordCompressorFactory = segmentRecordCompressorFactory;
    }

    public final int getWriteRetentionQueueCapacity() {
        return this.writeRetentionQueueCapacity;
    }

    public final void setWriteRetentionQueueCapacity(int v) {
        this.writeRetentionQueueCapacity = v;
    }

    public final int getWriteRetentionQueueScan() {
        return this.writeRetentionQueueScan;
    }

    public final void setWriteRetentionQueueScan(int v) {
        this.writeRetentionQueueScan = v;
    }

    public final LocalPartitionMetadata getPartitionMetadata() {
        return this.pmd;
    }

    public final String getBTreeClassName() {
        return this.btreeClassName;
    }

    public final String getCheckpointClassName() {
        return this.checkpointClassName;
    }

    public final void setCheckpointClassName(String className) {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        this.checkpointClassName = className;
    }

    public final IRabaCoder getNodeKeySerializer() {
        return this.nodeKeysCoder;
    }

    public final ITupleSerializer getTupleSerializer() {
        return this.tupleSer;
    }

    public final IConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public final boolean getDeleteMarkers() {
        return this.deleteMarkers;
    }

    public final void setDeleteMarkers(boolean deleteMarkers) {
        this.deleteMarkers = deleteMarkers;
    }

    public final boolean getVersionTimestamps() {
        return this.versionTimestamps;
    }

    public final boolean getVersionTimestampFilters() {
        return this.versionTimestampFilters;
    }

    public final void setVersionTimestampFilters(boolean versionTimestampFilters) {
        this.versionTimestampFilters = versionTimestampFilters;
    }

    public final void setVersionTimestamps(boolean versionTimestamps) {
        this.versionTimestamps = versionTimestamps;
    }

    public final boolean isIsolatable() {
        return this.deleteMarkers && this.versionTimestamps;
    }

    public void setIsolatable(boolean isolatable) {
        this.setDeleteMarkers(isolatable);
        this.setVersionTimestamps(isolatable);
    }

    public final boolean getRawRecords() {
        return this.rawRecords;
    }

    public final void setRawRecords(boolean rawRecords) {
        this.rawRecords = rawRecords;
    }

    public final int getMaxRecLen() {
        return this.maxRecLen;
    }

    public final void setMaxRecLen(int maxRecLen) {
        if (maxRecLen < 0 || maxRecLen > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.maxRecLen = (short)maxRecLen;
    }

    public void setPartitionMetadata(LocalPartitionMetadata pmd) {
        this.pmd = pmd;
    }

    public void setNodeKeySerializer(IRabaCoder nodeKeysCoder) {
        if (nodeKeysCoder == null) {
            throw new IllegalArgumentException();
        }
        this.nodeKeysCoder = nodeKeysCoder;
    }

    public void setTupleSerializer(ITupleSerializer tupleSer) {
        if (tupleSer == null) {
            throw new IllegalArgumentException();
        }
        this.tupleSer = tupleSer;
    }

    public void setBranchingFactor(int branchingFactor) {
        if (branchingFactor < 3) {
            throw new IllegalArgumentException();
        }
        this.branchingFactor = branchingFactor;
    }

    public void setIndexSegmentBranchingFactor(int branchingFactor) {
        if (branchingFactor < 3) {
            throw new IllegalArgumentException();
        }
        this.indexSegmentBranchingFactor = branchingFactor;
    }

    public void setBTreeClassName(String className) {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        this.btreeClassName = className;
    }

    public void setConflictResolver(IConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    public BloomFilterFactory getBloomFilterFactory() {
        return this.bloomFilterFactory;
    }

    public void setBloomFilterFactory(BloomFilterFactory bloomFilterFactory) {
        this.bloomFilterFactory = bloomFilterFactory;
    }

    public IOverflowHandler getOverflowHandler() {
        return this.overflowHandler;
    }

    public void setOverflowHandler(IOverflowHandler overflowHandler) {
        this.overflowHandler = overflowHandler;
    }

    public ISimpleSplitHandler getSplitHandler() {
        return this.splitHandler2;
    }

    public void setSplitHandler(ISimpleSplitHandler splitHandler) {
        this.splitHandler2 = splitHandler;
    }

    public AsynchronousIndexWriteConfiguration getAsynchronousIndexWriteConfiguration() {
        return this.asynchronousIndexWriteConfiguration;
    }

    public void getAsynchronousIndexWriteConfiguration(AsynchronousIndexWriteConfiguration newVal) {
        if (newVal == null) {
            throw new IllegalArgumentException();
        }
        this.asynchronousIndexWriteConfiguration = newVal;
    }

    public ScatterSplitConfiguration getScatterSplitConfiguration() {
        return this.scatterSplitConfiguration;
    }

    public void setScatterSplitConfiguration(ScatterSplitConfiguration newVal) {
        if (newVal == null) {
            throw new IllegalArgumentException();
        }
        this.scatterSplitConfiguration = newVal;
    }

    private static <T> T newInstance(String className, Class<T> iface) {
        if (iface == null) {
            throw new IllegalArgumentException();
        }
        if (className == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(className);
            if (!iface.isAssignableFrom(cls)) {
                throw new IllegalArgumentException("Does not implement " + cls + " : " + className);
            }
            return (T)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IndexMetadata() {
    }

    public IndexMetadata(UUID indexUUID) {
        this(null, indexUUID);
    }

    public IndexMetadata(String name, UUID indexUUID) {
        this(null, System.getProperties(), name, indexUUID, IndexTypeEnum.BTree);
    }

    public IndexMetadata(IIndexManager indexManager, Properties properties, String namespace, UUID indexUUID, IndexTypeEnum indexType) {
        if (indexUUID == null) {
            throw new IllegalArgumentException();
        }
        if (indexType == null) {
            throw new IllegalArgumentException();
        }
        this.name = namespace;
        this.indexType = indexType;
        this.indexUUID = indexUUID;
        String val = this.getProperty(indexManager, properties, namespace, Options.INITIAL_DATA_SERVICE, null);
        if (val != null) {
            IBigdataFederation fed;
            IDataService dataService;
            UUID uuid;
            block9: {
                uuid = null;
                try {
                    uuid = UUID.fromString(val);
                }
                catch (Throwable t) {
                    if (!log.isInfoEnabled()) break block9;
                    log.info((Object)("Not a UUID: " + val));
                }
            }
            if (uuid == null && indexManager != null && indexManager instanceof IBigdataFederation && (dataService = (fed = (IBigdataFederation)indexManager).getDataServiceByName(val)) != null) {
                try {
                    uuid = dataService.getServiceUUID();
                }
                catch (IOException ex) {
                    log.warn((Object)"Could not get serviceUUID", (Throwable)ex);
                }
            }
            this.initialDataServiceUUID = uuid;
        }
        this.branchingFactor = this.getProperty(indexManager, properties, namespace, Options.BTREE_BRANCHING_FACTOR, "32", new IntegerRangeValidator(3, 4196));
        String defaultCapacity = "500";
        this.writeRetentionQueueCapacity = this.getProperty(indexManager, properties, namespace, Options.WRITE_RETENTION_QUEUE_CAPACITY, defaultCapacity, new IntegerRangeValidator(2, 50000));
        this.writeRetentionQueueScan = this.getProperty(indexManager, properties, namespace, Options.WRITE_RETENTION_QUEUE_SCAN, "20", IntegerValidator.GTE_ZERO);
        this.btreeRecordCompressorFactory = IndexMetadata.newInstance(this.getProperty(indexManager, properties, namespace, Options.BTREE_RECORD_COMPRESSOR_FACTORY, Options.DEFAULT_BTREE_RECORD_COMPRESSOR_FACTORY), IRecordCompressorFactory.class);
        this.indexSegmentBranchingFactor = this.getProperty(indexManager, properties, namespace, Options.INDEX_SEGMENT_BRANCHING_FACTOR, "512", new IntegerRangeValidator(3, 10240));
        this.indexSegmentBufferNodes = Boolean.parseBoolean(this.getProperty(indexManager, properties, namespace, Options.INDEX_SEGMENT_BUFFER_NODES, "false"));
        this.indexSegmentRecordCompressorFactory = IndexMetadata.newInstance(this.getProperty(indexManager, properties, namespace, Options.INDEX_SEGMENT_RECORD_COMPRESSOR_FACTORY, Options.DEFAULT_INDEX_SEGMENT_RECORD_COMPRESSOR_FACTORY), IRecordCompressorFactory.class);
        this.pmd = null;
        this.btreeClassName = this.getProperty(indexManager, properties, namespace, Options.BTREE_CLASS_NAME, BTree.class.getName()).intern();
        this.checkpointClassName = Checkpoint.class.getName().intern();
        Class keyRabaCoder = this instanceof HTreeIndexMetadata ? FrontCodedRabaCoderDupKeys.class : FrontCodedRabaCoder.DefaultFrontCodedRabaCoder.class;
        this.nodeKeysCoder = IndexMetadata.newInstance(this.getProperty(indexManager, properties, namespace, Options.NODE_KEYS_CODER, keyRabaCoder.getName()), IRabaCoder.class);
        IKeyBuilderFactory keyBuilderFactory = DefaultTupleSerializer.getDefaultKeyBuilderFactory();
        IRabaCoder leafKeysCoder = IndexMetadata.newInstance(this.getProperty(indexManager, properties, namespace, Options.LEAF_KEYS_CODER, keyRabaCoder.getName()), IRabaCoder.class);
        IRabaCoder valuesCoder = IndexMetadata.newInstance(this.getProperty(indexManager, properties, namespace, Options.LEAF_VALUES_CODER, CanonicalHuffmanRabaCoder.class.getName()), IRabaCoder.class);
        this.tupleSer = new DefaultTupleSerializer(keyBuilderFactory, leafKeysCoder, valuesCoder);
        this.conflictResolver = null;
        this.deleteMarkers = false;
        this.versionTimestamps = false;
        this.versionTimestampFilters = false;
        this.rawRecords = false;
        this.maxRecLen = Short.parseShort(this.getProperty(indexManager, properties, namespace, Options.MAX_REC_LEN, "256"));
        boolean bloomFilter = Boolean.parseBoolean(this.getProperty(indexManager, properties, namespace, Options.BLOOM_FILTER, "false"));
        this.bloomFilterFactory = bloomFilter ? BloomFilterFactory.DEFAULT : null;
        this.overflowHandler = null;
        this.splitHandler2 = null;
        int masterQueueCapacity = Integer.parseInt(this.getProperty(indexManager, properties, namespace, Options.MASTER_QUEUE_CAPACITY, "5000"));
        int masterChunkSize = Integer.parseInt(this.getProperty(indexManager, properties, namespace, Options.MASTER_CHUNK_SIZE, "10000"));
        long masterChunkTimeoutNanos = Long.parseLong(this.getProperty(indexManager, properties, namespace, Options.MASTER_CHUNK_TIMEOUT_NANOS, Options.DEFAULT_MASTER_CHUNK_TIMEOUT_NANOS));
        long sinkIdleTimeoutNanos = Long.parseLong(this.getProperty(indexManager, properties, namespace, Options.SINK_IDLE_TIMEOUT_NANOS, "9223372036854775807"));
        long sinkPollTimeoutNanos = Long.parseLong(this.getProperty(indexManager, properties, namespace, Options.SINK_POLL_TIMEOUT_NANOS, Options.DEFAULT_SINK_POLL_TIMEOUT_NANOS));
        int sinkQueueCapacity = Integer.parseInt(this.getProperty(indexManager, properties, namespace, Options.SINK_QUEUE_CAPACITY, "5000"));
        int sinkChunkSize = Integer.parseInt(this.getProperty(indexManager, properties, namespace, Options.SINK_CHUNK_SIZE, "10000"));
        long sinkChunkTimeoutNanos = Long.parseLong(this.getProperty(indexManager, properties, namespace, Options.SINK_CHUNK_TIMEOUT_NANOS, "9223372036854775807"));
        this.asynchronousIndexWriteConfiguration = new AsynchronousIndexWriteConfiguration(masterQueueCapacity, masterChunkSize, masterChunkTimeoutNanos, sinkIdleTimeoutNanos, sinkPollTimeoutNanos, sinkQueueCapacity, sinkChunkSize, sinkChunkTimeoutNanos);
        boolean scatterSplitEnabled = Boolean.parseBoolean(this.getProperty(indexManager, properties, namespace, Options.SCATTER_SPLIT_ENABLED, "true"));
        double scatterSplitPercentOfSplitThreshold = Double.parseDouble(this.getProperty(indexManager, properties, namespace, Options.SCATTER_SPLIT_PERCENT_OF_SPLIT_THRESHOLD, ".25"));
        int scatterSplitDataServicesCount = Integer.parseInt(this.getProperty(indexManager, properties, namespace, Options.SCATTER_SPLIT_DATA_SERVICE_COUNT, "0"));
        int scatterSplitIndexPartitionsCount = Integer.parseInt(this.getProperty(indexManager, properties, namespace, Options.SCATTER_SPLIT_INDEX_PARTITION_COUNT, "0"));
        this.scatterSplitConfiguration = new ScatterSplitConfiguration(scatterSplitEnabled, scatterSplitPercentOfSplitThreshold, scatterSplitDataServicesCount, scatterSplitIndexPartitionsCount);
        if (log.isInfoEnabled()) {
            log.info((Object)this.toString());
        }
    }

    public void write(IRawStore store) {
        if (this.addrMetadata != 0L) {
            throw new IllegalStateException("Already written.");
        }
        if (this.indexUUID == null) {
            throw new IllegalStateException("No indexUUID : wrong constructor?");
        }
        this.addrMetadata = store.write(ByteBuffer.wrap(SerializerUtil.serialize(this)));
    }

    public static IndexMetadata read(IRawStore store, long addr) {
        IndexMetadata metadata = (IndexMetadata)SerializerUtil.deserialize(store.read(addr));
        metadata.addrMetadata = addr;
        return metadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("addrMetadata=" + this.addrMetadata);
        sb.append(", name=" + (this.name == null ? "N/A" : this.name));
        sb.append(", indexType=" + (Object)((Object)this.indexType));
        sb.append(", indexUUID=" + this.indexUUID);
        if (this.initialDataServiceUUID != null) {
            sb.append(", initialDataServiceUUID=" + this.initialDataServiceUUID);
        }
        sb.append(", branchingFactor=" + this.branchingFactor);
        sb.append(", pmd=" + this.pmd);
        sb.append(", btreeClassName=" + this.btreeClassName);
        sb.append(", checkpointClass=" + this.checkpointClassName);
        sb.append(", nodeKeysCoder=" + this.nodeKeysCoder);
        sb.append(", btreeRecordCompressorFactory=" + (this.btreeRecordCompressorFactory == null ? "N/A" : this.btreeRecordCompressorFactory));
        sb.append(", tupleSerializer=" + this.tupleSer);
        sb.append(", conflictResolver=" + (this.conflictResolver == null ? "N/A" : this.conflictResolver.getClass().getName()));
        sb.append(", deleteMarkers=" + this.deleteMarkers);
        sb.append(", versionTimestamps=" + this.versionTimestamps);
        sb.append(", versionTimestampFilters=" + this.versionTimestampFilters);
        sb.append(", isolatable=" + this.isIsolatable());
        sb.append(", rawRecords=" + this.rawRecords);
        sb.append(", maxRecLen=" + this.maxRecLen);
        sb.append(", bloomFilterFactory=" + (this.bloomFilterFactory == null ? "N/A" : this.bloomFilterFactory.toString()));
        sb.append(", overflowHandler=" + (this.overflowHandler == null ? "N/A" : this.overflowHandler.getClass().getName()));
        sb.append(", splitHandler=" + (this.splitHandler2 == null ? "N/A" : this.splitHandler2.toString()));
        sb.append(", indexSegmentBranchingFactor=" + this.indexSegmentBranchingFactor);
        sb.append(", indexSegmentBufferNodes=" + this.indexSegmentBufferNodes);
        sb.append(", indexSegmentRecordCompressorFactory=" + (this.indexSegmentRecordCompressorFactory == null ? "N/A" : this.indexSegmentRecordCompressorFactory));
        sb.append(", asynchronousIndexWriteConfiguration=" + this.asynchronousIndexWriteConfiguration);
        sb.append(", scatterSplitConfiguration=" + this.scatterSplitConfiguration);
        this.toString(sb);
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = this.version = (int)LongPacker.unpackLong(in);
        switch (version) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IOException("Unknown version: version=" + version);
            }
        }
        boolean hasName = in.readBoolean();
        if (hasName) {
            this.name = in.readUTF();
        }
        this.indexType = version >= 4 ? IndexTypeEnum.valueOf(in.readShort()) : IndexTypeEnum.BTree;
        this.indexUUID = new UUID(in.readLong(), in.readLong());
        this.branchingFactor = (int)LongPacker.unpackLong(in);
        this.writeRetentionQueueCapacity = (int)LongPacker.unpackLong(in);
        this.writeRetentionQueueScan = (int)LongPacker.unpackLong(in);
        this.pmd = (LocalPartitionMetadata)in.readObject();
        this.btreeClassName = in.readUTF();
        this.checkpointClassName = in.readUTF();
        this.nodeKeysCoder = (IRabaCoder)in.readObject();
        this.tupleSer = (ITupleSerializer)in.readObject();
        this.btreeRecordCompressorFactory = (IRecordCompressorFactory)in.readObject();
        this.conflictResolver = (IConflictResolver)in.readObject();
        this.deleteMarkers = in.readBoolean();
        if (version >= 1) {
            this.rawRecords = in.readBoolean();
            this.maxRecLen = in.readShort();
        } else {
            this.rawRecords = false;
            this.maxRecLen = Short.parseShort("256");
        }
        this.versionTimestamps = in.readBoolean();
        this.versionTimestampFilters = in.readBoolean();
        this.bloomFilterFactory = (BloomFilterFactory)in.readObject();
        this.overflowHandler = (IOverflowHandler)in.readObject();
        this.splitHandler2 = (ISimpleSplitHandler)in.readObject();
        this.indexSegmentBranchingFactor = (int)LongPacker.unpackLong(in);
        this.indexSegmentBufferNodes = in.readBoolean();
        this.indexSegmentRecordCompressorFactory = (IRecordCompressorFactory)in.readObject();
        this.asynchronousIndexWriteConfiguration = (AsynchronousIndexWriteConfiguration)in.readObject();
        this.scatterSplitConfiguration = (ScatterSplitConfiguration)in.readObject();
        if (version >= 2 && version < 4) {
            if (version >= 3) {
                LongPacker.unpackInt(in);
            }
            LongPacker.unpackInt(in);
            in.readUTF();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int version = 4;
        LongPacker.packLong(out, 4L);
        out.writeBoolean(this.name != null);
        if (this.name != null) {
            out.writeUTF(this.name);
        }
        out.writeShort(this.indexType.getCode());
        out.writeLong(this.indexUUID.getMostSignificantBits());
        out.writeLong(this.indexUUID.getLeastSignificantBits());
        LongPacker.packLong(out, (long)this.branchingFactor);
        LongPacker.packLong(out, (long)this.writeRetentionQueueCapacity);
        LongPacker.packLong(out, (long)this.writeRetentionQueueScan);
        out.writeObject(this.pmd);
        out.writeUTF(this.btreeClassName);
        out.writeUTF(this.checkpointClassName);
        out.writeObject(this.nodeKeysCoder);
        out.writeObject(this.tupleSer);
        out.writeObject(this.btreeRecordCompressorFactory);
        out.writeObject(this.conflictResolver);
        out.writeBoolean(this.deleteMarkers);
        out.writeBoolean(this.rawRecords);
        out.writeShort(this.maxRecLen);
        out.writeBoolean(this.versionTimestamps);
        out.writeBoolean(this.versionTimestampFilters);
        out.writeObject(this.bloomFilterFactory);
        out.writeObject(this.overflowHandler);
        out.writeObject(this.splitHandler2);
        LongPacker.packLong(out, (long)this.indexSegmentBranchingFactor);
        out.writeBoolean(this.indexSegmentBufferNodes);
        out.writeObject(this.btreeRecordCompressorFactory);
        out.writeObject(this.asynchronousIndexWriteConfiguration);
        out.writeObject(this.scatterSplitConfiguration);
    }

    public IndexMetadata clone() {
        try {
            IndexMetadata copy = (IndexMetadata)super.clone();
            copy.addrMetadata = 0L;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final Checkpoint firstCheckpoint() {
        String checkpointClassName = this.getCheckpointClassName();
        if (checkpointClassName == null) {
            throw new RuntimeException("checkpointClassName not set: did you use the deserialization constructor by mistake?");
        }
        try {
            Class<?> cl = Class.forName(checkpointClassName);
            Constructor<?> ctor = cl.getConstructor(IndexMetadata.class);
            Checkpoint checkpoint = (Checkpoint)ctor.newInstance(this);
            return checkpoint;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public final Checkpoint overflowCheckpoint(Checkpoint oldCheckpoint) {
        if (oldCheckpoint == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class<?> cl = Class.forName(this.getCheckpointClassName());
            Constructor<?> ctor = cl.getConstructor(IndexMetadata.class, Checkpoint.class);
            Checkpoint checkpoint = (Checkpoint)ctor.newInstance(this, oldCheckpoint);
            assert (checkpoint.getCounter() == oldCheckpoint.getCounter());
            return checkpoint;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public IKeyBuilder getKeyBuilder() {
        return this.getTupleSerializer().getKeyBuilder();
    }

    @Override
    public IKeyBuilder getPrimaryKeyBuilder() {
        return this.getTupleSerializer().getPrimaryKeyBuilder();
    }

    protected String getProperty(IIndexManager indexManager, Properties properties, String namespace, String globalName, String defaultValue) {
        return Configuration.getProperty(indexManager, properties, namespace, globalName, defaultValue);
    }

    protected <E> E getProperty(IIndexManager indexManager, Properties properties, String namespace, String globalName, String defaultValue, IValidator<E> validator) {
        return Configuration.getProperty(indexManager, properties, namespace, globalName, defaultValue, validator);
    }

    public static interface Options {
        public static final int MIN_BRANCHING_FACTOR = 3;
        public static final int MAX_BTREE_BRANCHING_FACTOR = 4196;
        public static final int MAX_INDEX_SEGMENT_BRANCHING_FACTOR = 10240;
        public static final int MIN_WRITE_RETENTION_QUEUE_CAPACITY = 2;
        public static final int MAX_WRITE_RETENTION_QUEUE_CAPACITY = 50000;
        public static final String BLOOM_FILTER = (BTree.class.getPackage().getName() + ".bloomFilter").intern();
        public static final String DEFAULT_BLOOM_FILTER = "false";
        public static final String MAX_REC_LEN = (BTree.class.getPackage().getName() + ".maxRecLen").intern();
        public static final String DEFAULT_MAX_REC_LEN = "256";
        public static final String INITIAL_DATA_SERVICE = BTree.class.getPackage().getName() + ".initialDataService";
        public static final String WRITE_RETENTION_QUEUE_CAPACITY = (AbstractBTree.class.getPackage().getName() + ".writeRetentionQueue.capacity").intern();
        public static final String WRITE_RETENTION_QUEUE_SCAN = (AbstractBTree.class.getPackage().getName() + ".writeRetentionQueue.scan").intern();
        public static final String DEFAULT_WRITE_RETENTION_QUEUE_CAPACITY = "500";
        public static final String DEFAULT_WRITE_RETENTION_QUEUE_SCAN = "20";
        public static final String KEY_BUILDER_FACTORY = (AbstractBTree.class.getPackage().getName() + "keyBuilderFactory").intern();
        public static final String NODE_KEYS_CODER = (AbstractBTree.class.getPackage().getName() + "nodeKeysCoder").intern();
        public static final String LEAF_KEYS_CODER = (AbstractBTree.class.getPackage().getName() + ".leafKeysCoder").intern();
        public static final String LEAF_VALUES_CODER = (AbstractBTree.class.getPackage().getName() + ".leafValuesCoder").intern();
        public static final String BTREE_CLASS_NAME = (BTree.class.getName() + ".className").intern();
        public static final String BTREE_BRANCHING_FACTOR = (BTree.class.getName() + ".branchingFactor").intern();
        public static final String DEFAULT_BTREE_BRANCHING_FACTOR = "32";
        public static final String BTREE_RECORD_COMPRESSOR_FACTORY = (BTree.class.getName() + ".recordCompressorFactory").intern();
        public static final String DEFAULT_BTREE_RECORD_COMPRESSOR_FACTORY = null;
        public static final String INDEX_SEGMENT_BRANCHING_FACTOR = (IndexSegment.class.getName() + ".branchingFactor").intern();
        public static final String DEFAULT_INDEX_SEGMENT_BRANCHING_FACTOR = "512";
        public static final String INDEX_SEGMENT_BUFFER_NODES = (IndexSegment.class.getName() + ".bufferNodes").intern();
        public static final String DEFAULT_INDEX_SEGMENT_BUFFER_NODES = "false";
        public static final String INDEX_SEGMENT_RECORD_COMPRESSOR_FACTORY = (IndexSegment.class.getName() + ".recordCompressorFactory").intern();
        public static final String DEFAULT_INDEX_SEGMENT_RECORD_COMPRESSOR_FACTORY = null;
        public static final String MASTER_QUEUE_CAPACITY = (AsynchronousIndexWriteConfiguration.class.getName() + ".masterQueueCapacity").intern();
        public static final String DEFAULT_MASTER_QUEUE_CAPACITY = "5000";
        public static final String MASTER_CHUNK_SIZE = (AsynchronousIndexWriteConfiguration.class.getName() + ".masterChunkSize").intern();
        public static final String DEFAULT_MASTER_CHUNK_SIZE = "10000";
        public static final String MASTER_CHUNK_TIMEOUT_NANOS = (AsynchronousIndexWriteConfiguration.class.getName() + ".masterChunkTimeoutNanos").intern();
        public static final String DEFAULT_MASTER_CHUNK_TIMEOUT_NANOS = "" + TimeUnit.MILLISECONDS.toNanos(50L);
        public static final String SINK_POLL_TIMEOUT_NANOS = (AsynchronousIndexWriteConfiguration.class.getName() + ".sinkPollTimeoutNanos").intern();
        public static final String DEFAULT_SINK_POLL_TIMEOUT_NANOS = "" + TimeUnit.MILLISECONDS.toNanos(50L);
        public static final String SINK_QUEUE_CAPACITY = (AsynchronousIndexWriteConfiguration.class.getName() + ".sinkQueueCapacity").intern();
        public static final String DEFAULT_SINK_QUEUE_CAPACITY = "5000";
        public static final String SINK_CHUNK_SIZE = (AsynchronousIndexWriteConfiguration.class.getName() + ".sinkChunkSize").intern();
        public static final String DEFAULT_SINK_CHUNK_SIZE = "10000";
        public static final String SINK_CHUNK_TIMEOUT_NANOS = (AsynchronousIndexWriteConfiguration.class.getName() + ".sinkChunkTimeoutNanos").intern();
        public static final String DEFAULT_SINK_CHUNK_TIMEOUT_NANOS = "9223372036854775807";
        public static final String SINK_IDLE_TIMEOUT_NANOS = (AsynchronousIndexWriteConfiguration.class.getName() + ".sinkIdleTimeoutNanos").intern();
        public static final String DEFAULT_SINK_IDLE_TIMEOUT_NANOS = "9223372036854775807";
        public static final String SCATTER_SPLIT_ENABLED = (ScatterSplitConfiguration.class.getName() + ".enabled").intern();
        public static final String DEFAULT_SCATTER_SPLIT_ENABLED = "true";
        public static final String SCATTER_SPLIT_PERCENT_OF_SPLIT_THRESHOLD = (ScatterSplitConfiguration.class.getName() + ".percentOfSplitThreshold").intern();
        public static final String DEFAULT_SCATTER_SPLIT_PERCENT_OF_SPLIT_THRESHOLD = ".25";
        public static final String SCATTER_SPLIT_DATA_SERVICE_COUNT = (ScatterSplitConfiguration.class.getName() + ".dataServiceCount").intern();
        public static final String DEFAULT_SCATTER_SPLIT_DATA_SERVICE_COUNT = "0";
        public static final String SCATTER_SPLIT_INDEX_PARTITION_COUNT = (ScatterSplitConfiguration.class.getName() + ".indexPartitionCount").intern();
        public static final String DEFAULT_SCATTER_SPLIT_INDEX_PARTITION_COUNT = "0";
    }
}

