/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.ThreadLocalKeyBuilderFactory;
import com.bigdata.btree.raba.codec.CanonicalHuffmanRabaCoder;
import com.bigdata.btree.raba.codec.FrontCodedRabaCoder;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.SerializerUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;

public class DefaultTupleSerializer<K, V>
implements ITupleSerializer<K, V>,
Externalizable {
    private static final long serialVersionUID = 2211020411074955099L;
    private IRabaCoder leafKeysCoder;
    private IRabaCoder leafValsCoder;
    private IKeyBuilderFactory delegateKeyBuilderFactory;
    private transient IKeyBuilderFactory threadLocalKeyBuilderFactory;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public static final IKeyBuilderFactory getDefaultKeyBuilderFactory() {
        return new DefaultKeyBuilderFactory(new Properties());
    }

    public static final IRabaCoder getDefaultLeafKeysCoder() {
        return FrontCodedRabaCoder.DefaultFrontCodedRabaCoder.INSTANCE;
    }

    public static final IRabaCoder getDefaultValuesCoder() {
        return CanonicalHuffmanRabaCoder.INSTANCE;
    }

    @Override
    public final IRabaCoder getLeafKeysCoder() {
        return this.leafKeysCoder;
    }

    @Override
    public final IRabaCoder getLeafValuesCoder() {
        return this.leafValsCoder;
    }

    public final void setLeafKeysCoder(IRabaCoder leafKeysCoder) {
        if (leafKeysCoder == null) {
            throw new IllegalArgumentException();
        }
        this.leafKeysCoder = leafKeysCoder;
    }

    public final void setLeafValuesCoder(IRabaCoder valuesCoder) {
        if (valuesCoder == null) {
            throw new IllegalArgumentException();
        }
        this.leafValsCoder = valuesCoder;
    }

    public static ITupleSerializer newInstance() {
        return new DefaultTupleSerializer(DefaultTupleSerializer.getDefaultKeyBuilderFactory());
    }

    public DefaultTupleSerializer() {
    }

    public DefaultTupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
        this(keyBuilderFactory, DefaultTupleSerializer.getDefaultLeafKeysCoder(), DefaultTupleSerializer.getDefaultValuesCoder());
    }

    public DefaultTupleSerializer(IKeyBuilderFactory keyBuilderFactory, IRabaCoder leafKeysCoder, IRabaCoder leafValsCoder) {
        if (keyBuilderFactory == null) {
            throw new IllegalArgumentException();
        }
        if (leafKeysCoder == null) {
            throw new IllegalArgumentException();
        }
        if (leafValsCoder == null) {
            throw new IllegalArgumentException();
        }
        this.threadLocalKeyBuilderFactory = new ThreadLocalKeyBuilderFactory(keyBuilderFactory);
        this.delegateKeyBuilderFactory = keyBuilderFactory;
        this.leafKeysCoder = leafKeysCoder;
        this.leafValsCoder = leafValsCoder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName() + "{");
        sb.append(", keyBuilderFactory=" + this.delegateKeyBuilderFactory);
        sb.append(", leafKeysCoder=" + this.leafKeysCoder);
        sb.append(", leafValuesCoder=" + this.leafValsCoder);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final IKeyBuilder getKeyBuilder() {
        if (this.threadLocalKeyBuilderFactory == null) {
            throw new IllegalStateException();
        }
        return this.threadLocalKeyBuilderFactory.getKeyBuilder();
    }

    @Override
    public final IKeyBuilder getPrimaryKeyBuilder() {
        if (this.threadLocalKeyBuilderFactory == null) {
            throw new IllegalStateException();
        }
        return this.threadLocalKeyBuilderFactory.getPrimaryKeyBuilder();
    }

    @Override
    public byte[] serializeKey(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        return this.getKeyBuilder().reset().append(obj).getKey();
    }

    @Override
    public byte[] serializeVal(V obj) {
        return SerializerUtil.serialize(obj);
    }

    @Override
    public V deserialize(ITuple tuple) {
        if (tuple == null) {
            throw new IllegalArgumentException();
        }
        return (V)SerializerUtil.deserialize(tuple.getValue());
    }

    @Override
    public K deserializeKey(ITuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                this.delegateKeyBuilderFactory = (IKeyBuilderFactory)in.readObject();
                this.threadLocalKeyBuilderFactory = new ThreadLocalKeyBuilderFactory(this.delegateKeyBuilderFactory);
                this.leafKeysCoder = (IRabaCoder)in.readObject();
                this.leafValsCoder = (IRabaCoder)in.readObject();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeObject(this.delegateKeyBuilderFactory);
        out.writeObject(this.leafKeysCoder);
        out.writeObject(this.leafValsCoder);
    }
}

