/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.BigdataMap;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITupleIterator;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class BigdataSet<E>
extends AbstractSet<E>
implements SortedSet<E> {
    protected static final transient String ERR_TOO_MANY = "Too many entries";
    private final BigdataMap<E, E> map;

    public BigdataSet(IIndex ndx) {
        this.map = new BigdataMap(ndx);
    }

    BigdataSet(BigdataMap<E, E> map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.map = map;
    }

    @Override
    public boolean add(E key) {
        E tmp = this.map.put(key, key);
        return tmp == null;
    }

    @Override
    public boolean remove(Object key) {
        E tmp = this.map.remove(key);
        return tmp != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public long rangeCount(boolean exactCount) {
        return this.map.rangeCount(exactCount);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return super.addAll(c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public final Comparator<? super E> comparator() {
        return null;
    }

    @Override
    public E first() {
        IIndex ndx = this.map.getIndex();
        ITupleIterator itr = ndx.rangeIterator(this.map.fromKey, this.map.toKey, 1, 3, null);
        if (!itr.hasNext()) {
            throw new NoSuchElementException();
        }
        return (E)this.map.tupleSer.deserialize(itr.next());
    }

    @Override
    public E last() {
        IIndex ndx = this.map.getIndex();
        ITupleIterator itr = ndx.rangeIterator(this.map.fromKey, this.map.toKey, 1, 67, null);
        if (!itr.hasNext()) {
            throw new NoSuchElementException();
        }
        return (E)this.map.tupleSer.deserialize(itr.next());
    }

    @Override
    public SortedSet<E> headSet(E toKey) {
        return new BigdataSet<E>((BigdataMap)this.map.headMap(toKey));
    }

    @Override
    public SortedSet<E> subSet(E fromKey, E toKey) {
        return new BigdataSet<E>((BigdataMap)this.map.subMap(fromKey, toKey));
    }

    @Override
    public SortedSet<E> tailSet(E fromKey) {
        return new BigdataSet<E>((BigdataMap)this.map.tailMap(fromKey));
    }
}

