/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.TargetType;
import org.apache.jena.shacl.engine.Targets;
import org.apache.jena.shacl.lib.G;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ConstraintComponents;
import org.apache.jena.shacl.parser.Constraints;
import org.apache.jena.shacl.parser.NodeShape;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.validation.Severity;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ShapesParser {
    private static final boolean DEBUG = false;
    private static IndentedWriter OUT = IndentedWriter.stdout;
    private static Set<RDFDatatype> decimalCompatible = new HashSet<RDFDatatype>();

    public static Targets targets(Graph shapesGraph) {
        return Targets.create(shapesGraph);
    }

    public static Collection<Shape> parseShapes(Graph shapesGraph, Targets targets, Map<Node, Shape> shapesMap) {
        Targets rootShapes = targets;
        ConstraintComponents sparqlConstraintComponents = ConstraintComponents.parseSparqlConstraintComponents(shapesGraph);
        LinkedHashMap<Node, Shape> acc = new LinkedHashMap<Node, Shape>();
        for (Node shapeNode : rootShapes.targetNodes) {
            ShapesParser.parseRootShape(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : rootShapes.targetClasses) {
            ShapesParser.parseRootShape(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : rootShapes.targetObjectsOf) {
            ShapesParser.parseRootShape(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : rootShapes.targetSubjectsOf) {
            ShapesParser.parseRootShape(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : rootShapes.implicitClassTargets) {
            ShapesParser.parseRootShape(acc, shapesMap, shapesGraph, shapeNode);
        }
        if (sparqlConstraintComponents != null && !sparqlConstraintComponents.isEmpty()) {
            shapesMap.values().forEach(shape -> {
                List<Constraint> x = ConstraintComponents.processShape(shapesGraph, sparqlConstraintComponents, shape);
                if (x != null && !x.isEmpty()) {
                    shape.getConstraints().addAll(x);
                }
            });
        }
        return ShapesParser.shapes(acc);
    }

    public static Collection<Shape> declaredShapes(Graph shapesGraph, Map<Node, Shape> _shapesMap) {
        HashMap shapesMap = _shapesMap == null ? new HashMap() : _shapesMap;
        LinkedHashMap<Node, Shape> acc = new LinkedHashMap<Node, Shape>();
        G.listAllNodesOfType(shapesGraph, SHACL.NodeShape).forEach(shapeNode -> ShapesParser.parseRootShape(acc, shapesMap, shapesGraph, shapeNode));
        G.listAllNodesOfType(shapesGraph, SHACL.PropertyShape).forEach(shapeNode -> ShapesParser.parseRootShape(acc, shapesMap, shapesGraph, shapeNode));
        return ShapesParser.shapes(acc);
    }

    private static Collection<Shape> shapes(Map<Node, Shape> acc) {
        return new ArrayList<Shape>(acc.values());
    }

    private static void parseRootShape(Map<Node, Shape> acc, Map<Node, Shape> parsed, Graph shapesGraph, Node shNode) {
        if (acc.containsKey(shNode)) {
            return;
        }
        Shape shape = ShapesParser.parseShapeStep(parsed, shapesGraph, shNode);
        acc.put(shNode, shape);
    }

    public static Shape parseShape(Graph shapesGraph, Node shNode) {
        HashMap<Node, Shape> parsed = new HashMap<Node, Shape>();
        return ShapesParser.parseShapeStep(parsed, shapesGraph, shNode);
    }

    static Shape parseShapeStep(Map<Node, Shape> parsed, Graph shapesGraph, Node shapeNode) {
        if (parsed.containsKey(shapeNode)) {
            return parsed.get(shapeNode);
        }
        Shape shape = ShapesParser.parseShape$(parsed, shapesGraph, shapeNode);
        parsed.put(shapeNode, shape);
        return shape;
    }

    private static Shape parseShape$(Map<Node, Shape> parsed, Graph shapesGraph, Node shapeNode) {
        boolean isDeactivated = G.absentOrOne(shapesGraph, shapeNode, SHACL.deactivated, NodeConst.nodeTrue);
        Collection<Target> targets = ShapesParser.targets(shapesGraph, shapeNode);
        List<Constraint> constraints = Constraints.parseConstraints(shapesGraph, shapeNode, parsed);
        Severity severity = ShapesParser.severity(shapesGraph, shapeNode);
        List<Node> messages = G.listSP(shapesGraph, shapeNode, SHACL.message);
        List<PropertyShape> propertyShapes = ShapesParser.findPropertyShapes(parsed, shapesGraph, shapeNode);
        boolean isPropertyShape = G.contains(shapesGraph, shapeNode, SHACL.path, Node.ANY);
        if (!isPropertyShape) {
            return new NodeShape(shapesGraph, shapeNode, isDeactivated, severity, messages, targets, constraints, propertyShapes);
        }
        Node pathNode = G.getOneSP(shapesGraph, shapeNode, SHACL.path);
        Path path = ShapesParser.parsePath(shapesGraph, pathNode);
        List<Node> names = G.listSP(shapesGraph, shapeNode, SHACL.name);
        List<Node> descriptions = G.listSP(shapesGraph, shapeNode, SHACL.description);
        List<Node> groups = G.listSP(shapesGraph, shapeNode, SHACL.group);
        Node defaultValue = G.getZeroOrOneSP(shapesGraph, shapeNode, SHACL.defaultValue);
        Node order = G.getZeroOrOneSP(shapesGraph, shapeNode, SHACL.order);
        if (order != null && !ShapesParser.isDecimalCompatible(order)) {
            throw new ShaclParseException("Not an xsd:decimal for sh:order");
        }
        return new PropertyShape(shapesGraph, shapeNode, isDeactivated, severity, messages, targets, path, constraints, propertyShapes);
    }

    private static boolean isDecimalCompatible(Node node) {
        try {
            RDFDatatype dt = node.getLiteralDatatype();
            return decimalCompatible.contains(dt);
        }
        catch (JenaException ex) {
            return false;
        }
    }

    private static Path parsePath(Graph shapesGraph, Node node) {
        return ShaclPaths.parsePath(shapesGraph, node);
    }

    private static List<PropertyShape> findPropertyShapes(Map<Node, Shape> parsed, Graph shapesGraph, Node shapeNode) {
        List propertyTriples = G.find(shapesGraph, shapeNode, SHACL.property, null).toList();
        ArrayList<PropertyShape> propertyShapes = new ArrayList<PropertyShape>();
        for (Triple t : propertyTriples) {
            Node propertyShape = G.object(t);
            long x = G.countSP(shapesGraph, propertyShape, SHACL.path);
            if (x == 0L) {
                boolean existsAsSubject = G.contains(shapesGraph, propertyShape, null, null);
                if (!existsAsSubject) {
                    throw new ShaclParseException("Missing property shape: node=" + ShLib.displayStr(shapeNode) + " sh:property " + ShLib.displayStr(propertyShape));
                }
                throw new ShaclParseException("No sh:path on a property shape: node=" + ShLib.displayStr(shapeNode) + " sh:property " + ShLib.displayStr(propertyShape));
            }
            if (x > 1L) {
                List<Node> paths = G.listSP(shapesGraph, propertyShape, SHACL.path);
                throw new ShaclParseException("Muiltiple sh:path on a property shape: " + ShLib.displayStr(shapeNode) + " sh:property" + ShLib.displayStr(propertyShape) + " : " + paths);
            }
            PropertyShape ps = (PropertyShape)ShapesParser.parseShapeStep(parsed, shapesGraph, propertyShape);
            propertyShapes.add(ps);
        }
        return propertyShapes;
    }

    private static Collection<Target> targets(Graph shapesGraph, Node shape) {
        ArrayList<Target> x = new ArrayList<Target>();
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetNode);
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetClass);
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetObjectsOf);
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetSubjectsOf);
        if (ShapesParser.isShapeType(shapesGraph, shape) && G.isOfType(shapesGraph, shape, C.rdfsClass)) {
            x.add(Target.create(TargetType.implicitClass, shape));
        }
        return x;
    }

    private static boolean isShapeType(Graph shapesGraph, Node shape) {
        return G.hasType(shapesGraph, shape, SHACL.NodeShape) || G.hasType(shapesGraph, shape, SHACL.PropertyShape);
    }

    private static Severity severity(Graph shapesGraph, Node shNode) {
        Node sev = G.getSP(shapesGraph, shNode, SHACL.severity);
        if (sev == null) {
            return Severity.Violation;
        }
        return Severity.create(sev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void accTarget(Collection<Target> acc, Graph shapesGraph, Node shape, TargetType targetType) {
        try (ExtendedIterator iter = shapesGraph.find(shape, targetType.predicate, null);){
            iter.mapWith(triple -> Target.create(targetType, triple.getObject())).forEachRemaining(target -> acc.add((Target)target));
        }
    }

    static {
        decimalCompatible.add((RDFDatatype)XSDDatatype.XSDdecimal);
        decimalCompatible.add((RDFDatatype)XSDDatatype.XSDinteger);
        decimalCompatible.add((RDFDatatype)XSDDatatype.XSDlong);
        decimalCompatible.add((RDFDatatype)XSDDatatype.XSDint);
    }

    static class ParserState {
        Targets rootShapes;
        ConstraintComponents sparqlConstraintComponents;
        Map<Node, Shape> shapesMap;

        ParserState() {
        }
    }
}

