/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact;

import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.shacl.compact.ShaclcParser;
import org.apache.jena.sparql.util.Context;

public class SHACLC {
    public static void init() {
        ReaderRIOTFactory factory = (language, profile) -> new ReaderRIOTShaclc();
        RDFParserRegistry.registerLangTriples((Lang)Lang.SHACLC, (ReaderRIOTFactory)factory);
    }

    static class ReaderRIOTShaclc
    implements ReaderRIOT {
        ReaderRIOTShaclc() {
        }

        public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context) {
            Graph g = ShaclcParser.parseSHACLC(reader, baseURI);
            StreamRDFOps.sendGraphToStream((Graph)g, (StreamRDF)output);
        }

        public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
            Graph g = ShaclcParser.parseSHACLC(in, baseURI);
            StreamRDFOps.sendGraphToStream((Graph)g, (StreamRDF)output);
        }
    }
}

