/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class StrConcat
extends BaseBuiltin {
    public String getName() {
        return "strConcat";
    }

    public int getArgLength() {
        return 0;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length < 1) {
            throw new BuiltinException(this, context, "Must have at least 1 argument to " + this.getName());
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < length - 1; ++i) {
            buff.append(this.lex(this.getArg(i, args, context), context));
        }
        Node result = Node.createLiteral(buff.toString());
        return context.getEnv().bind(args[length - 1], result);
    }

    protected String lex(Node n, RuleContext context) {
        if (n.isBlank()) {
            return n.getBlankNodeLabel();
        }
        if (n.isURI()) {
            return n.getURI();
        }
        if (n.isLiteral()) {
            return n.getLiteralLexicalForm();
        }
        throw new BuiltinException(this, context, "Illegal node type: " + n);
    }
}

