/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLStorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWLStorer
implements OWLStorer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractOWLStorer.class);

    private static OutputStream prepareActualOutput(IRI documentIRI) throws IOException {
        if ("file".equals(documentIRI.getScheme())) {
            File file = new File(documentIRI.toURI());
            file.getParentFile().mkdirs();
            return new FileOutputStream(file);
        }
        URL url = documentIRI.toURI().toURL();
        URLConnection conn = url.openConnection();
        return conn.getOutputStream();
    }

    @Override
    public void storeOntology(OWLOntology ontology, IRI documentIRI, OWLDocumentFormat ontologyFormat) throws OWLOntologyStorageException {
        if (!documentIRI.isAbsolute()) {
            throw new OWLOntologyStorageException("Document IRI must be absolute: " + documentIRI);
        }
        try (OutputStream os = AbstractOWLStorer.prepareActualOutput(documentIRI);){
            this.store(ontology, ontologyFormat, os);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    private void store(OWLOntology ontology, OWLDocumentFormat ontologyFormat, OutputStream tempOutputStream) throws OWLOntologyStorageException, IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(tempOutputStream, StandardCharsets.UTF_8);
             BufferedWriter bw = new BufferedWriter(osw);
             PrintWriter tempWriter = new PrintWriter(bw);){
            this.storeOntology(ontology, tempWriter, ontologyFormat);
            tempWriter.flush();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void storeOntology(OWLOntology ontology, OWLOntologyDocumentTarget target, OWLDocumentFormat format) throws OWLOntologyStorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract void storeOntology(OWLOntology var1, PrintWriter var2, OWLDocumentFormat var3) throws OWLOntologyStorageException;

    protected void storeOntology(OWLOntology ontology, OutputStream outputStream, OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (!format.isTextual()) {
            throw new OWLOntologyStorageException("This method must be overridden to support this binary format: " + format.getKey());
        }
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)));
            this.storeOntology(ontology, writer, format);
            writer.flush();
        }
        catch (OWLRuntimeException e) {
            throw new OWLOntologyStorageException(e);
        }
    }
}

