/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLObject;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface SWRLRule
extends OWLLogicalAxiom,
SWRLObject {
    @Override
    default public Stream<?> components() {
        return Stream.of(this.body(), this.head(), this.annotations());
    }

    @Override
    default public Stream<?> componentsWithoutAnnotations() {
        return Stream.of(this.body(), this.head());
    }

    @Override
    default public Stream<?> componentsAnnotationsFirst() {
        return Stream.of(this.annotations(), this.body(), this.head());
    }

    @Override
    default public int hashIndex() {
        return 631;
    }

    @Deprecated
    default public Set<SWRLAtom> getBody() {
        return OWLAPIStreamUtils.asSet(this.body());
    }

    public Stream<SWRLAtom> body();

    @Deprecated
    default public Set<SWRLAtom> getHead() {
        return OWLAPIStreamUtils.asSet(this.head());
    }

    public Stream<SWRLAtom> head();

    public SWRLRule getSimplified();

    @Deprecated
    default public Set<SWRLVariable> getVariables() {
        return OWLAPIStreamUtils.asSet(this.variables());
    }

    public Stream<SWRLVariable> variables();

    public boolean containsAnonymousClassExpressions();

    @Deprecated
    default public Set<OWLClassExpression> getClassAtomPredicates() {
        return OWLAPIStreamUtils.asSet(this.classAtomPredicates());
    }

    public Stream<OWLClassExpression> classAtomPredicates();

    public SWRLRule getAxiomWithoutAnnotations();

    @Override
    default public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public void accept(SWRLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(SWRLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public AxiomType<?> getAxiomType() {
        return AxiomType.SWRL_RULE;
    }
}

