/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Optional;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDocumentTarget
implements OWLOntologyDocumentTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDocumentTarget.class);
    private final File file;

    public FileDocumentTarget(File file) {
        this.file = OWLAPIPreconditions.checkNotNull(file, "file cannot be null");
    }

    @Override
    public Optional<Writer> getWriter() {
        try {
            return OWLAPIPreconditions.optional(new BufferedWriter(new FileWriter(this.file)));
        }
        catch (IOException e) {
            LOGGER.error("Writer cannot be created", (Throwable)e);
            return OWLAPIPreconditions.emptyOptional();
        }
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        try {
            return OWLAPIPreconditions.optional(new BufferedOutputStream(new FileOutputStream(this.file)));
        }
        catch (IOException e) {
            LOGGER.error("Input stream cannot be created", (Throwable)e);
            return OWLAPIPreconditions.emptyOptional();
        }
    }

    @Override
    public Optional<IRI> getDocumentIRI() {
        return OWLAPIPreconditions.optional(IRI.create(this.file));
    }
}

