/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.DefaultMetadataFactory;
import com.bigdata.ganglia.IGangliaMetadataFactory;
import com.bigdata.ganglia.IGangliaMetadataMessage;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;

public class GangliaMetadataFactory
implements IGangliaMetadataFactory {
    private final CopyOnWriteArraySet<IGangliaMetadataFactory> list = new CopyOnWriteArraySet();
    private final IGangliaMetadataFactory defaultFactory;

    public GangliaMetadataFactory(DefaultMetadataFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new IllegalArgumentException();
        }
        this.defaultFactory = defaultFactory;
    }

    public void add(IGangliaMetadataFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        this.list.add(factory);
    }

    @Override
    public IGangliaMetadataMessage newDecl(String hostName, String metricName, Object value) {
        Iterator<IGangliaMetadataFactory> itr = this.list.iterator();
        IGangliaMetadataMessage decl = null;
        while (itr.hasNext() && decl == null) {
            IGangliaMetadataFactory impl = itr.next();
            decl = impl.newDecl(hostName, metricName, value);
        }
        if (decl == null) {
            decl = this.defaultFactory.newDecl(hostName, metricName, value);
        }
        return decl;
    }

    @Override
    public IGangliaMetadataMessage resolve(IGangliaMetadataMessage decl) {
        return decl;
    }
}

