/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.rdbms.schema.Batch;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.openrdf.sail.rdbms.schema.RdbmsTable;
import org.openrdf.sail.rdbms.schema.TripleBatch;
import org.openrdf.sail.rdbms.schema.TripleTable;

public class TransactionTable {
    private int batchSize;
    private TripleTable triples;
    private int addedCount;
    private int removedCount;
    private RdbmsTable temporary;
    private Connection conn;
    private TripleBatch batch;
    private BlockingQueue<Batch> queue;
    private DefaultSailChangedEvent sailChangedEvent;
    private IdSequence ids;
    private PreparedStatement insertSelect;

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
    }

    public void setQueue(BlockingQueue<Batch> queue) {
        this.queue = queue;
    }

    public void setTemporaryTable(RdbmsTable table) {
        this.temporary = table;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public TripleTable getTripleTable() {
        return this.triples;
    }

    public void setTripleTable(TripleTable statements) {
        this.triples = statements;
    }

    public void setSailChangedEvent(DefaultSailChangedEvent sailChangedEvent) {
        this.sailChangedEvent = sailChangedEvent;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    public void close() throws SQLException {
        if (this.insertSelect != null) {
            this.insertSelect.close();
        }
        this.temporary.close();
    }

    public synchronized void insert(Number ctx, Number subj, Number pred, Number obj) throws SQLException, InterruptedException {
        if (this.batch == null || this.batch.isFull() || !this.queue.remove(this.batch)) {
            this.batch = this.newTripleBatch();
            this.batch.setTable(this.triples);
            this.batch.setSailChangedEvent(this.sailChangedEvent);
            this.batch.setTemporary(this.temporary);
            this.batch.setMaxBatchSize(this.getBatchSize());
            this.batch.setBatchStatement(this.prepareInsert());
            if (this.insertSelect == null) {
                this.insertSelect = this.prepareInsertSelect(this.buildInsertSelect());
            }
            this.batch.setInsertStatement(this.insertSelect);
        }
        this.batch.setObject(1, ctx);
        this.batch.setObject(2, subj);
        if (this.temporary == null && !this.triples.isPredColumnPresent()) {
            this.batch.setObject(3, obj);
            this.batch.setObject(4, true);
        } else {
            this.batch.setObject(3, pred);
            this.batch.setObject(4, obj);
            this.batch.setObject(5, true);
        }
        this.batch.addBatch();
        this.queue.put(this.batch);
        ++this.addedCount;
        this.triples.getSubjTypes().add(this.ids.valueOf(subj));
        this.triples.getObjTypes().add(this.ids.valueOf(obj));
    }

    public void committed() throws SQLException {
        this.triples.modified(this.addedCount, this.removedCount);
        this.addedCount = 0;
        this.removedCount = 0;
    }

    public void removed(int count) throws SQLException {
        this.removedCount += count;
    }

    public boolean isEmpty() throws SQLException {
        return this.triples.isEmpty() && this.addedCount == 0;
    }

    public String toString() {
        return this.triples.toString();
    }

    protected TripleBatch newTripleBatch() {
        return new TripleBatch();
    }

    protected PreparedStatement prepareInsertSelect(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    protected String buildInsertSelect() throws SQLException {
        String tableName = this.triples.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(tableName).append("\n");
        sb.append("SELECT DISTINCT ctx, subj, ");
        if (this.triples.isPredColumnPresent()) {
            sb.append("pred, ");
        }
        sb.append("obj, expl FROM ");
        sb.append(this.temporary.getName()).append(" tr\n");
        sb.append("WHERE NOT EXISTS (");
        sb.append("SELECT * FROM ");
        sb.append(tableName).append(" st\n");
        sb.append("WHERE st.ctx = tr.ctx");
        sb.append(" AND st.subj = tr.subj");
        if (this.triples.isPredColumnPresent()) {
            sb.append(" AND st.pred = tr.pred");
        }
        sb.append(" AND st.obj = tr.obj");
        sb.append(" AND st.expl = tr.expl");
        sb.append(")");
        return sb.toString();
    }

    protected PreparedStatement prepareInsert(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    protected String buildInsert(String tableName, boolean predColumnPresent) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(tableName);
        sb.append(" (ctx, subj, ");
        if (predColumnPresent) {
            sb.append("pred, ");
        }
        sb.append("obj, expl)\n");
        sb.append("VALUES (?, ?, ");
        if (predColumnPresent) {
            sb.append("?, ");
        }
        sb.append("?, ?)");
        return sb.toString();
    }

    protected boolean isPredColumnPresent() {
        return this.triples.isPredColumnPresent();
    }

    private PreparedStatement prepareInsert() throws SQLException {
        if (this.temporary == null) {
            boolean present = this.triples.isPredColumnPresent();
            String sql = this.buildInsert(this.triples.getName(), present);
            return this.prepareInsert(sql);
        }
        String sql = this.buildInsert(this.temporary.getName(), true);
        return this.prepareInsert(sql);
    }
}

