/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteHash;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteIterators;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ByteOpenCustomHashSet
extends AbstractByteSet
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient byte[] key;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected ByteHash.Strategy strategy;

    public ByteOpenCustomHashSet(int expected, float f, ByteHash.Strategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new byte[this.n];
        this.used = new boolean[this.n];
    }

    public ByteOpenCustomHashSet(int expected, ByteHash.Strategy strategy) {
        this(expected, 0.75f, strategy);
    }

    public ByteOpenCustomHashSet(ByteHash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public ByteOpenCustomHashSet(Collection<? extends Byte> c, float f, ByteHash.Strategy strategy) {
        this(c.size(), f, strategy);
        this.addAll(c);
    }

    public ByteOpenCustomHashSet(Collection<? extends Byte> c, ByteHash.Strategy strategy) {
        this(c, 0.75f, strategy);
    }

    public ByteOpenCustomHashSet(ByteCollection c, float f, ByteHash.Strategy strategy) {
        this(c.size(), f, strategy);
        this.addAll(c);
    }

    public ByteOpenCustomHashSet(ByteCollection c, ByteHash.Strategy strategy) {
        this(c, 0.75f, strategy);
    }

    public ByteOpenCustomHashSet(ByteIterator i, float f, ByteHash.Strategy strategy) {
        this(16, f, strategy);
        while (i.hasNext()) {
            this.add(i.nextByte());
        }
    }

    public ByteOpenCustomHashSet(ByteIterator i, ByteHash.Strategy strategy) {
        this(i, 0.75f, strategy);
    }

    public ByteOpenCustomHashSet(Iterator<?> i, float f, ByteHash.Strategy strategy) {
        this(ByteIterators.asByteIterator(i), f, strategy);
    }

    public ByteOpenCustomHashSet(Iterator<?> i, ByteHash.Strategy strategy) {
        this(ByteIterators.asByteIterator(i), strategy);
    }

    public ByteOpenCustomHashSet(byte[] a, int offset, int length, float f, ByteHash.Strategy strategy) {
        this(length < 0 ? 0 : length, f, strategy);
        ByteArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public ByteOpenCustomHashSet(byte[] a, int offset, int length, ByteHash.Strategy strategy) {
        this(a, offset, length, 0.75f, strategy);
    }

    public ByteOpenCustomHashSet(byte[] a, float f, ByteHash.Strategy strategy) {
        this(a, 0, a.length, f, strategy);
    }

    public ByteOpenCustomHashSet(byte[] a, ByteHash.Strategy strategy) {
        this(a, 0.75f, strategy);
    }

    public ByteHash.Strategy strategy() {
        return this.strategy;
    }

    @Override
    public boolean add(byte k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                return false;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.strategy.hashCode(this.key[pos]) ^ this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public boolean remove(byte k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                --this.size;
                this.shiftKeys(pos);
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean contains(byte k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    @Override
    public ByteIterator iterator() {
        return new SetIterator();
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        byte[] key = this.key;
        int mask = newN - 1;
        byte[] newKey = new byte[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            byte k = key[i];
            int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.used = newUsed;
    }

    public ByteOpenCustomHashSet clone() {
        ByteOpenCustomHashSet c;
        try {
            c = (ByteOpenCustomHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (byte[])this.key.clone();
        c.used = (boolean[])this.used.clone();
        c.strategy = this.strategy;
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.size;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            h += this.strategy.hashCode(this.key[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ByteIterator i = this.iterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            s.writeByte(i.nextByte());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new byte[this.n];
        byte[] key = this.key;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            byte k = s.readByte();
            pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
        }
    }

    private void checkTable() {
    }

    private class SetIterator
    extends AbstractByteIterator {
        int pos;
        int last;
        int c;
        ByteArrayList wrapped;

        private SetIterator() {
            this.pos = ByteOpenCustomHashSet.this.n;
            this.last = -1;
            this.c = ByteOpenCustomHashSet.this.size;
            boolean[] used = ByteOpenCustomHashSet.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.c != 0;
        }

        @Override
        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                return this.wrapped.getByte(-this.pos - 2);
            }
            this.last = this.pos;
            byte retVal = ByteOpenCustomHashSet.this.key[this.last];
            if (this.c != 0) {
                boolean[] used = ByteOpenCustomHashSet.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return retVal;
        }

        final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & ByteOpenCustomHashSet.this.mask;
                while (ByteOpenCustomHashSet.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(ByteOpenCustomHashSet.this.strategy.hashCode(ByteOpenCustomHashSet.this.key[pos]) ^ ByteOpenCustomHashSet.this.mask) & ByteOpenCustomHashSet.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & ByteOpenCustomHashSet.this.mask;
                }
                if (!ByteOpenCustomHashSet.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new ByteArrayList();
                    }
                    this.wrapped.add(ByteOpenCustomHashSet.this.key[pos]);
                }
                ByteOpenCustomHashSet.this.key[last] = ByteOpenCustomHashSet.this.key[pos];
            }
            ByteOpenCustomHashSet.this.used[last] = false;
            return last;
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                ByteOpenCustomHashSet.this.remove(this.wrapped.getByte(-this.pos - 2));
                this.last = -1;
                return;
            }
            --ByteOpenCustomHashSet.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextByte();
            }
            this.last = -1;
        }
    }
}

