/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.map.writer.OSMTagMapping;
import org.mapsforge.map.writer.model.NodeResolver;
import org.mapsforge.map.writer.model.OSMTag;
import org.mapsforge.map.writer.model.SpecialTagExtractionResult;
import org.mapsforge.map.writer.model.TDNode;
import org.mapsforge.map.writer.model.TDRelation;
import org.mapsforge.map.writer.util.OSMUtils;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;

public class TDWay {
    public static final byte LINE = 0;
    public static final byte MULTI_POLYGON = 2;
    public static final byte SIMPLE_POLYGON = 1;
    private static final Logger LOGGER = Logger.getLogger(TDWay.class.getName());
    private final String houseNumber;
    private final long id;
    private boolean invalid;
    private final byte layer;
    private String name;
    private String ref;
    private boolean reversedInRelation;
    private byte shape;
    private Map<Short, Object> tags;
    private final TDNode[] wayNodes;

    public static TDWay fromWay(Way way, NodeResolver resolver, List<String> preferredLanguages) {
        if (way == null) {
            return null;
        }
        SpecialTagExtractionResult ster = OSMUtils.extractSpecialFields((Entity)way, preferredLanguages);
        Map<Short, Object> knownWayTags = OSMUtils.extractKnownWayTags((Entity)way);
        if (way.getWayNodes().size() >= 2) {
            boolean validWay = true;
            TDNode[] waynodes = new TDNode[way.getWayNodes().size()];
            int i = 0;
            for (WayNode waynode : way.getWayNodes()) {
                waynodes[i] = resolver.getNode(waynode.getNodeId());
                if (waynodes[i] == null) {
                    validWay = false;
                    LOGGER.finer("unknown way node: " + waynode.getNodeId() + " in way " + way.getId());
                }
                ++i;
            }
            if (validWay) {
                byte shape = 0;
                if (waynodes[0].getId() == waynodes[waynodes.length - 1].getId()) {
                    if (waynodes.length >= 4) {
                        if (OSMUtils.isArea(way)) {
                            shape = 1;
                        }
                    } else {
                        LOGGER.finer("Found closed polygon with fewer than 4 way nodes. Way-id: " + way.getId());
                        return null;
                    }
                }
                return new TDWay(way.getId(), ster.getLayer(), ster.getName(), ster.getHousenumber(), ster.getRef(), knownWayTags, shape, waynodes);
            }
        }
        return null;
    }

    public TDWay(long id, byte layer, String name, String houseNumber, String ref, Map<Short, Object> tags, byte shape, TDNode[] wayNodes) {
        this.id = id;
        this.layer = layer;
        this.name = name;
        this.houseNumber = houseNumber;
        this.ref = ref;
        this.tags = tags;
        this.shape = shape;
        this.wayNodes = wayNodes;
    }

    public TDWay(long id, byte layer, String name, String houseNumber, String ref, TDNode[] wayNodes) {
        this.id = id;
        this.layer = layer;
        this.name = name;
        this.houseNumber = houseNumber;
        this.ref = ref;
        this.wayNodes = wayNodes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TDWay other = (TDWay)obj;
        return this.id == other.id;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public long getId() {
        return this.id;
    }

    public byte getLayer() {
        return this.layer;
    }

    public byte getMinimumZoomLevel() {
        return OSMTagMapping.getInstance().getZoomAppearWay(this.tags.keySet());
    }

    public String getName() {
        return this.name;
    }

    public String getRef() {
        return this.ref;
    }

    public byte getShape() {
        return this.shape;
    }

    public Map<Short, Object> getTags() {
        return this.tags;
    }

    public TDNode[] getWayNodes() {
        return this.wayNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean hasTags() {
        return this.tags != null && this.tags.size() > 0;
    }

    public boolean isCoastline() {
        List<OSMTag> osmTags = OSMTagMapping.getInstance().getWayTags(this.tags.keySet());
        for (OSMTag tag : osmTags) {
            if (!tag.isCoastline()) continue;
            return true;
        }
        return false;
    }

    public boolean isForcePolygonLine() {
        if (!this.hasTags()) {
            return false;
        }
        List<OSMTag> osmTags = OSMTagMapping.getInstance().getWayTags(this.tags.keySet());
        for (OSMTag tag : osmTags) {
            if (!tag.isForcePolygonLine()) continue;
            return true;
        }
        return false;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isPartElement() {
        List<OSMTag> osmTags = OSMTagMapping.getInstance().getWayTags(this.tags.keySet());
        for (OSMTag tag : osmTags) {
            if (!tag.isBuildingPart()) continue;
            return true;
        }
        return false;
    }

    public boolean isRenderRelevant() {
        return this.hasTags() || this.getName() != null && !this.getName().isEmpty() || this.getRef() != null && !this.getRef().isEmpty();
    }

    public boolean isReversedInRelation() {
        return this.reversedInRelation;
    }

    public boolean isRootElement() {
        List<OSMTag> osmTags = OSMTagMapping.getInstance().getWayTags(this.tags.keySet());
        for (OSMTag tag : osmTags) {
            if (!tag.isBuilding()) continue;
            return true;
        }
        return false;
    }

    public boolean isValidClosedLine() {
        return this.wayNodes != null && this.wayNodes.length >= 4 && this.wayNodes[0].getId() == this.wayNodes[this.wayNodes.length - 1].getId();
    }

    public void mergeRelationInformation(TDRelation relation) {
        if (relation.hasTags()) {
            this.addTags(relation.getTags());
        }
        if (this.getName() == null && relation.getName() != null) {
            this.setName(relation.getName());
        }
        if (this.getRef() == null && relation.getRef() != null) {
            this.setRef(relation.getRef());
        }
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setReversedInRelation(boolean reversedInRelation) {
        this.reversedInRelation = reversedInRelation;
    }

    public void setShape(byte shape) {
        this.shape = shape;
    }

    public void setTags(Map<Short, Object> tags) {
        this.tags = tags;
    }

    public String toString() {
        return "TDWay [id=" + this.id + (this.wayNodes.length > 0 ? ", latitude=" + LatLongUtils.microdegreesToDegrees(this.wayNodes[0].getLatitude()) + ", longitude=" + LatLongUtils.microdegreesToDegrees(this.wayNodes[0].getLongitude()) : "") + ", name=" + this.name + ", tags=" + Arrays.toString(this.tags.keySet().toArray()) + ", polygon=" + this.shape + "]";
    }

    public String toStringDetailed() {
        return "TDWay [id=" + this.id + (this.wayNodes.length > 0 ? ", latitude=" + LatLongUtils.microdegreesToDegrees(this.wayNodes[0].getLatitude()) + ", longitude=" + LatLongUtils.microdegreesToDegrees(this.wayNodes[0].getLongitude()) : "") + ", name=" + this.name + ", tags=" + OSMUtils.tagsToString(this.tags, true) + ", polygon=" + this.shape + "]";
    }

    private void addTags(Map<Short, Object> addendum) {
        if (this.tags == null) {
            this.tags = addendum;
        } else if (addendum != null) {
            this.tags.putAll(addendum);
        }
    }
}

