/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer;

import java.security.InvalidParameterException;

public final class Serializer {
    public static byte[] getBytes(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static byte[] getBytes(long value) {
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static byte[] getBytes(short value) {
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    public static byte[] getFiveBytes(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("negative value not allowed: " + value);
        }
        if (value > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("value out of range: " + value);
        }
        return new byte[]{(byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static byte[] getVariableByteSigned(int value) {
        long absValue = Math.abs((long)value);
        if (absValue < 64L) {
            if (value < 0) {
                return new byte[]{(byte)(absValue | 0x40L)};
            }
            return new byte[]{(byte)absValue};
        }
        if (absValue < 8192L) {
            if (value < 0) {
                return new byte[]{(byte)(absValue | 0x80L), (byte)(absValue >> 7 | 0x40L)};
            }
            return new byte[]{(byte)(absValue | 0x80L), (byte)(absValue >> 7)};
        }
        if (absValue < 0x100000L) {
            if (value < 0) {
                return new byte[]{(byte)(absValue | 0x80L), (byte)(absValue >> 7 | 0x80L), (byte)(absValue >> 14 | 0x40L)};
            }
            return new byte[]{(byte)(absValue | 0x80L), (byte)(absValue >> 7 | 0x80L), (byte)(absValue >> 14)};
        }
        if (absValue < 0x8000000L) {
            if (value < 0) {
                return new byte[]{(byte)(absValue | 0x80L), (byte)(absValue >> 7 | 0x80L), (byte)(absValue >> 14 | 0x80L), (byte)(absValue >> 21 | 0x40L)};
            }
            return new byte[]{(byte)(absValue | 0x80L), (byte)(absValue >> 7 | 0x80L), (byte)(absValue >> 14 | 0x80L), (byte)(absValue >> 21)};
        }
        if (value < 0) {
            return new byte[]{(byte)(absValue | 0x80L), (byte)(absValue >> 7 | 0x80L), (byte)(absValue >> 14 | 0x80L), (byte)(absValue >> 21 | 0x80L), (byte)(absValue >> 28 | 0x40L)};
        }
        return new byte[]{(byte)(absValue | 0x80L), (byte)(absValue >> 7 | 0x80L), (byte)(absValue >> 14 | 0x80L), (byte)(absValue >> 21 | 0x80L), (byte)(absValue >> 28)};
    }

    public static byte[] getVariableByteUnsigned(int value) {
        if (value < 0) {
            throw new InvalidParameterException("negative value not allowed: " + value);
        }
        if (value < 128) {
            return new byte[]{(byte)value};
        }
        if (value < 16384) {
            return new byte[]{(byte)(value | 0x80), (byte)(value >> 7)};
        }
        if (value < 0x200000) {
            return new byte[]{(byte)(value | 0x80), (byte)(value >> 7 | 0x80), (byte)(value >> 14)};
        }
        if (value < 0x10000000) {
            return new byte[]{(byte)(value | 0x80), (byte)(value >> 7 | 0x80), (byte)(value >> 14 | 0x80), (byte)(value >> 21)};
        }
        return new byte[]{(byte)(value | 0x80), (byte)(value >> 7 | 0x80), (byte)(value >> 14 | 0x80), (byte)(value >> 21 | 0x80), (byte)(value >> 28)};
    }

    private Serializer() {
        throw new IllegalStateException();
    }
}

