/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mapsforge.map.writer.Serializer;
import org.mapsforge.map.writer.model.Encoding;
import org.mapsforge.map.writer.model.WayDataBlock;

public final class DeltaEncoder {
    public static List<WayDataBlock> encode(List<WayDataBlock> blocks, Encoding encoding) {
        if (blocks == null) {
            return null;
        }
        if (encoding == Encoding.NONE) {
            return blocks;
        }
        ArrayList<WayDataBlock> results = new ArrayList<WayDataBlock>();
        for (WayDataBlock wayDataBlock : blocks) {
            List<Integer> outer = DeltaEncoder.mEncode(wayDataBlock.getOuterWay(), encoding);
            ArrayList<List<Integer>> inner = null;
            if (wayDataBlock.getInnerWays() != null) {
                inner = new ArrayList<List<Integer>>();
                for (List<Integer> list : wayDataBlock.getInnerWays()) {
                    inner.add(DeltaEncoder.mEncode(list, encoding));
                }
            }
            results.add(new WayDataBlock(outer, inner, encoding));
        }
        return results;
    }

    public static int simulateSerialization(List<WayDataBlock> blocks) {
        int sum = 0;
        for (WayDataBlock wayDataBlock : blocks) {
            sum += DeltaEncoder.mSimulateSerialization(wayDataBlock.getOuterWay());
            if (wayDataBlock.getInnerWays() == null) continue;
            for (List<Integer> list : wayDataBlock.getInnerWays()) {
                sum += DeltaEncoder.mSimulateSerialization(list);
            }
        }
        return sum;
    }

    static List<Integer> deltaEncode(List<Integer> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (list.isEmpty()) {
            return result;
        }
        Iterator<Integer> it = list.iterator();
        Integer prevLat = it.next();
        Integer prevLon = it.next();
        result.add(prevLat);
        result.add(prevLon);
        while (it.hasNext()) {
            Integer currentLat = it.next();
            Integer currentLon = it.next();
            result.add(currentLat - prevLat);
            result.add(currentLon - prevLon);
            prevLat = currentLat;
            prevLon = currentLon;
        }
        return result;
    }

    static List<Integer> doubleDeltaEncode(List<Integer> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (list.isEmpty()) {
            return result;
        }
        Iterator<Integer> it = list.iterator();
        Integer prevLat = it.next();
        Integer prevLon = it.next();
        Integer prevLatDelta = 0;
        Integer prevLonDelta = 0;
        result.add(prevLat);
        result.add(prevLon);
        while (it.hasNext()) {
            Integer currentLat = it.next();
            Integer currentLon = it.next();
            Integer deltaLat = currentLat - prevLat;
            Integer deltaLon = currentLon - prevLon;
            result.add(deltaLat - prevLatDelta);
            result.add(deltaLon - prevLonDelta);
            prevLat = currentLat;
            prevLon = currentLon;
            prevLatDelta = deltaLat;
            prevLonDelta = deltaLon;
        }
        return result;
    }

    private static List<Integer> mEncode(List<Integer> list, Encoding encoding) {
        switch (encoding) {
            case DELTA: {
                return DeltaEncoder.deltaEncode(list);
            }
            case DOUBLE_DELTA: {
                return DeltaEncoder.doubleDeltaEncode(list);
            }
            case NONE: {
                return list;
            }
        }
        throw new IllegalArgumentException("unknown encoding value: " + (Object)((Object)encoding));
    }

    private static int mSimulateSerialization(List<Integer> list) {
        int sum = 0;
        for (Integer coordinate : list) {
            sum += Serializer.getVariableByteSigned(coordinate).length;
        }
        return sum;
    }

    private DeltaEncoder() {
    }
}

