/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.mapelements;

import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.Filter;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;

public class SymbolContainer
extends MapElementContainer {
    public Bitmap symbol;
    public final float theta;

    public SymbolContainer(Point point, Display display, int priority, Rectangle boundary, Bitmap symbol) {
        this(point, display, priority, boundary, symbol, 0.0f);
    }

    public SymbolContainer(Point point, Display display, int priority, Rectangle boundary, Bitmap symbol, float theta) {
        super(point, display, priority);
        this.symbol = symbol;
        this.theta = theta;
        this.boundary = boundary;
        if (this.boundary == null) {
            double halfWidth = (double)this.symbol.getWidth() / 2.0;
            double halfHeight = (double)this.symbol.getHeight() / 2.0;
            this.boundary = new Rectangle(-halfWidth, -halfHeight, halfWidth, halfHeight);
        }
        this.symbol.incrementRefCount();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SymbolContainer)) {
            return false;
        }
        SymbolContainer other = (SymbolContainer)obj;
        return this.symbol == other.symbol;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.symbol.hashCode();
        return result;
    }

    @Override
    public void draw(Canvas canvas, Point origin, Matrix matrix, Filter filter) {
        matrix.reset();
        matrix.translate((int)(this.xy.x - origin.x + this.boundary.left), (int)(this.xy.y - origin.y + this.boundary.top));
        if (this.theta != 0.0f) {
            matrix.rotate(this.theta, (float)(-this.boundary.left), (float)(-this.boundary.top));
        }
        canvas.drawBitmap(this.symbol, matrix, 1.0f, filter);
    }
}

