/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.pgsimple.common.PointBuilder;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDataType;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityMapper;
import org.postgis.Geometry;
import org.postgis.PGgeometry;
import org.postgis.Point;

public class NodeMapper
extends EntityMapper<Node> {
    private PointBuilder pointBuilder = new PointBuilder();

    @Override
    public String getEntityName() {
        return "node";
    }

    @Override
    public ActionDataType getEntityType() {
        return ActionDataType.NODE;
    }

    @Override
    public Class<Node> getEntityClass() {
        return Node.class;
    }

    @Override
    protected String[] getTypeSpecificFieldNames() {
        return new String[]{"geom"};
    }

    @Override
    public Node parseRecord(ResultSet resultSet) {
        try {
            PGgeometry geom = (PGgeometry)resultSet.getObject("geom");
            Point point = (Point)geom.getGeometry();
            return new Node(new CommonEntityData(resultSet.getLong("id"), resultSet.getInt("version"), new Date(resultSet.getTimestamp("tstamp").getTime()), this.buildUser(resultSet), resultSet.getLong("changeset_id")), point.y, point.x);
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to build a node from the current recordset row.", (Throwable)e);
        }
    }

    @Override
    public int populateEntityParameters(PreparedStatement statement, int initialIndex, Node node) {
        int prmIndex = this.populateCommonEntityParameters(statement, initialIndex, (Entity)node);
        try {
            statement.setObject(prmIndex++, new PGgeometry((Geometry)this.pointBuilder.createPoint(node.getLatitude(), node.getLongitude())));
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to set a prepared statement parameter for node " + node.getId() + ".", (Throwable)e);
        }
        return prmIndex;
    }
}

