/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;

public class SchemaVersionValidator {
    private static final String SELECT_SQL = "SELECT version FROM schema_info";
    private DatabasePreferences preferences;
    private DatabaseContext dbCtx;
    private boolean validated;

    public SchemaVersionValidator(DatabaseContext dbCtx, DatabasePreferences preferences) {
        this.dbCtx = dbCtx;
        this.preferences = preferences;
    }

    public void validateVersion(int expectedVersion) {
        if (!this.validated) {
            this.validateDBVersion(expectedVersion);
            this.validated = true;
        }
    }

    private void validateDBVersion(int expectedVersion) {
        if (this.preferences.getValidateSchemaVersion()) {
            try {
                Statement statement = this.dbCtx.createStatement();
                ResultSet resultSet = statement.executeQuery(SELECT_SQL);
                if (!resultSet.next()) {
                    throw new OsmosisRuntimeException("No rows were found in the schema info table.");
                }
                int dbVersion = resultSet.getInt("version");
                if (dbVersion != expectedVersion) {
                    throw new OsmosisRuntimeException("The database schema version of " + dbVersion + " does not match the expected version of " + expectedVersion + ".");
                }
                resultSet.close();
                statement.close();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to read the schema version from the schema info table.", (Throwable)e);
            }
        }
    }
}

