/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6.impl;

import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.CharsetUtil;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceServerControl;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.ServerStatistics;

public abstract class SequenceServerHandler
extends SimpleChannelHandler {
    private static final Logger LOG = Logger.getLogger(SequenceServerHandler.class.getName());
    private SequenceServerControl control;
    private long currentSequenceNumber;

    public SequenceServerHandler(SequenceServerControl control) {
        this.control = control;
    }

    protected SequenceServerControl getControl() {
        return this.control;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.control.registerChannel(e.getChannel());
    }

    private void writeResourceNotFound(final ChannelHandlerContext ctx, String requestedUri) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_0, HttpResponseStatus.NOT_FOUND);
        response.headers().add("Content-Type", (Object)"text/plain");
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)("The requested resource does not exist: " + requestedUri), (Charset)CharsetUtil.UTF_8);
        response.setContent(buffer);
        ChannelFuture headerFuture = Channels.future((Channel)ctx.getChannel());
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)headerFuture, (Object)response);
        headerFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                ctx.getChannel().close();
            }
        });
    }

    private void writeResourceGone(final ChannelHandlerContext ctx, String requestedUri) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_0, HttpResponseStatus.GONE);
        response.headers().add("Content-Type", (Object)"text/plain");
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)("The requested resource is no longer available: " + requestedUri), (Charset)CharsetUtil.UTF_8);
        response.setContent(buffer);
        ChannelFuture headerFuture = Channels.future((Channel)ctx.getChannel());
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)headerFuture, (Object)response);
        headerFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                ctx.getChannel().close();
            }
        });
    }

    private void writeBadRequest(final ChannelHandlerContext ctx, String requestedUri, String errorMessage) {
        String newLine = "\r\n";
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_0, HttpResponseStatus.NOT_FOUND);
        response.headers().add("Content-Type", (Object)"text/plain");
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Bad Request").append("\r\n");
        messageBuilder.append("Message: ").append(errorMessage).append("\r\n");
        messageBuilder.append("Requested URI: ").append(requestedUri).append("\r\n");
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)messageBuilder.toString(), (Charset)CharsetUtil.UTF_8);
        response.setContent(buffer);
        ChannelFuture headerFuture = Channels.future((Channel)ctx.getChannel());
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)headerFuture, (Object)response);
        headerFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                ctx.getChannel().close();
            }
        });
    }

    private void writeStatistics(final ChannelHandlerContext ctx) {
        String newLine = "\r\n";
        ServerStatistics statistics = this.control.getStatistics();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_0, HttpResponseStatus.OK);
        response.headers().add("Content-Type", (Object)"text/plain");
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Server Statistics").append("\r\n");
        messageBuilder.append("Total Requests: ").append(statistics.getTotalRequests()).append("\r\n");
        messageBuilder.append("Active Connections: ").append(statistics.getActiveConnections()).append("\r\n");
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)messageBuilder.toString(), (Charset)CharsetUtil.UTF_8);
        response.setContent(buffer);
        ChannelFuture headerFuture = Channels.future((Channel)ctx.getChannel());
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)headerFuture, (Object)response);
        headerFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                ctx.getChannel().close();
            }
        });
    }

    protected void initiateSequenceWriting(final ChannelHandlerContext ctx, String contentType, final long requestedSequenceNumber, final boolean follow) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().add("Content-Type", (Object)contentType);
        response.setChunked(true);
        response.headers().add("Transfer-Encoding", (Object)"chunked");
        ChannelFuture headerFuture = Channels.future((Channel)ctx.getChannel());
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)headerFuture, (Object)response);
        headerFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    SequenceServerHandler.this.control.determineNextChannelAction(ctx.getChannel(), requestedSequenceNumber, follow);
                }
            }
        });
    }

    protected abstract void handleRequest(ChannelHandlerContext var1, HttpRequest var2);

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        HttpRequest request = (HttpRequest)e.getMessage();
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Received new request from " + remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort());
        }
        try {
            if (request.getUri().equals("/statistics")) {
                this.writeStatistics(ctx);
            } else {
                this.handleRequest(ctx, request);
            }
        }
        catch (ResourceNotFoundException ex) {
            this.writeResourceNotFound(ctx, request.getUri());
        }
        catch (ResourceGoneException ex) {
            this.writeResourceGone(ctx, request.getUri());
        }
        catch (BadRequestException ex) {
            this.writeBadRequest(ctx, request.getUri(), ex.getMessage());
        }
    }

    protected abstract void writeSequence(ChannelHandlerContext var1, ChannelFuture var2, long var3);

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.currentSequenceNumber = (Long)e.getMessage();
        this.writeSequence(ctx, e.getFuture(), this.currentSequenceNumber);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable t = e.getCause();
        if (!(t instanceof ClosedChannelException)) {
            LOG.log(Level.SEVERE, "Error during processing for channel " + ctx.getChannel() + ".", t);
        }
        e.getChannel().close();
    }

    protected static class ResourceGoneException
    extends RuntimeException {
        private static final long serialVersionUID = -1L;

        protected ResourceGoneException() {
        }
    }

    protected static class BadRequestException
    extends RuntimeException {
        private static final long serialVersionUID = -1L;

        public BadRequestException(String message) {
            super(message);
        }
    }

    protected static class ResourceNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = -1L;

        protected ResourceNotFoundException() {
        }
    }
}

