/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6;

import java.net.InetSocketAddress;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.RunnableChangeSourceManager;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableChangeSource;
import org.openstreetmap.osmosis.replicationhttp.v0_6.ReplicationDataClient;

public class ReplicationDataClientFactory
extends TaskManagerFactory {
    private static final String ARG_HOST = "host";
    private static final String ARG_PORT = "port";
    private static final String ARG_PATH_PREFIX = "pathPrefix";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 0;
    private static final String DEFAULT_PATH_PREFIX = "";

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        String host = this.getStringArgument(taskConfig, ARG_HOST, DEFAULT_HOST);
        int port = this.getIntegerArgument(taskConfig, ARG_PORT, 0);
        StringBuilder basePath = new StringBuilder(this.getStringArgument(taskConfig, ARG_PATH_PREFIX, DEFAULT_PATH_PREFIX));
        while (basePath.length() > 0 && basePath.charAt(0) == '/') {
            basePath.delete(0, 1);
        }
        while (basePath.length() > 0 && basePath.charAt(basePath.length() - 1) == '/') {
            basePath.delete(basePath.length() - 1, basePath.length());
        }
        if (basePath.length() > 0) {
            basePath.insert(0, '/');
        }
        return new RunnableChangeSourceManager(taskConfig.getId(), (RunnableChangeSource)new ReplicationDataClient(new InetSocketAddress(host, port), basePath.toString()), taskConfig.getPipeArgs());
    }
}

