/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ReplicationQueryPredicates;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ReplicationSource;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ReplicationState;
import org.openstreetmap.osmosis.apidb.v0_6.impl.SystemTimeLoader;
import org.openstreetmap.osmosis.apidb.v0_6.impl.TransactionManager;
import org.openstreetmap.osmosis.apidb.v0_6.impl.TransactionSnapshot;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;

public class Replicator {
    private static final Logger LOG = Logger.getLogger(Replicator.class.getName());
    private static final int SPECIAL_TRANSACTION_OFFSET = 3;
    private static final int TRANSACTION_QUERY_SIZE_MAX = 25000;
    private ChangeSink changeSink;
    private ReplicationSource source;
    private TransactionManager txnManager;
    private SystemTimeLoader systemTimeLoader;
    private int iterations;
    private int minInterval;
    private int maxInterval;

    public Replicator(ReplicationSource source, ChangeSink changeSink, TransactionManager snapshotLoader, SystemTimeLoader systemTimeLoader, int iterations, int minInterval, int maxInterval) {
        this.source = source;
        this.changeSink = changeSink;
        this.txnManager = snapshotLoader;
        this.systemTimeLoader = systemTimeLoader;
        this.iterations = iterations;
        this.minInterval = minInterval;
        this.maxInterval = maxInterval;
    }

    private void obtainNewSnapshot(ReplicationState state) {
        TransactionSnapshot transactionSnapshot = this.txnManager.getTransactionSnapshot();
        state.setTxnMax(transactionSnapshot.getXMax());
        for (Long id : state.getTxnActive()) {
            if (transactionSnapshot.getXIpList().contains(id) || this.compareTxnIds(id, state.getTxnMaxQueried()) >= 0) continue;
            state.getTxnReady().add(id);
        }
        state.getTxnActive().clear();
        state.getTxnActive().addAll(transactionSnapshot.getXIpList());
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Updated replication state with new snapshot, maxTxnQueried=" + state.getTxnMaxQueried() + ", maxTxn=" + state.getTxnMax() + ", txnActiveList=" + state.getTxnActive() + ", txnReadyList=" + state.getTxnReady() + ".");
        }
    }

    private int compareTxnIds(long id1, long id2) {
        return (int)id1 - (int)id2;
    }

    private long incrementTxnId(long id, int increment) {
        int oldId = (int)id;
        int newId = oldId + increment;
        if (oldId < 0 && newId >= 0) {
            newId += 3;
        }
        return newId;
    }

    private ReplicationQueryPredicates buildQueryPredicates(ReplicationState state) {
        long topTransactionId = state.getTxnMax();
        int rangeLength = this.compareTxnIds(topTransactionId, state.getTxnMaxQueried());
        if (rangeLength > 25000) {
            topTransactionId = this.incrementTxnId(state.getTxnMaxQueried(), 25000);
        }
        ReplicationQueryPredicates predicates = new ReplicationQueryPredicates(state.getTxnMaxQueried(), topTransactionId);
        state.setTxnMaxQueried(topTransactionId);
        predicates.getActiveList().addAll(state.getTxnActive());
        predicates.getReadyList().addAll(state.getTxnReady());
        state.getTxnReady().clear();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Query predicates updated, bottomXid=" + predicates.getBottomTransactionId() + ", topXid=" + predicates.getTopTransactionId() + ", activeXidList=" + predicates.getActiveList() + ", readyXidList=" + predicates.getReadyList() + ".");
        }
        return predicates;
    }

    private void copyChanges(ReleasableIterator<ChangeContainer> sourceIterator, ReplicationState state) {
        try (ReleasableIterator<ChangeContainer> i = sourceIterator;){
            Date currentTimestamp = state.getTimestamp();
            while (i.hasNext()) {
                ChangeContainer change = (ChangeContainer)i.next();
                Date nextTimestamp = change.getEntityContainer().getEntity().getTimestamp();
                if (currentTimestamp.compareTo(nextTimestamp) < 0) {
                    currentTimestamp = nextTimestamp;
                }
                this.changeSink.process(change);
            }
            state.setTimestamp(currentTimestamp);
        }
    }

    public void replicate() {
        try {
            this.replicateLoop();
        }
        finally {
            this.changeSink.close();
        }
    }

    private void replicateLoop() {
        int iterationCount = 1;
        while (true) {
            this.txnManager.executeWithinTransaction(new Runnable(){

                @Override
                public void run() {
                    Replicator.this.replicateImpl();
                }
            });
            if (this.iterations > 0 && iterationCount >= this.iterations) break;
            ++iterationCount;
        }
        LOG.fine("Exiting replication loop.");
    }

    private void replicateImpl() {
        long remainingInterval;
        Date systemTimestamp;
        ReplicationState state = new ReplicationState();
        HashMap<String, ReplicationState> metaData = new HashMap<String, ReplicationState>(1);
        metaData.put("replication.state", state);
        this.changeSink.initialize(metaData);
        while (true) {
            systemTimestamp = this.systemTimeLoader.getSystemTime();
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Loaded system time " + systemTimestamp + " from the database.");
            }
            if ((remainingInterval = state.getTimestamp().getTime() + (long)this.minInterval - systemTimestamp.getTime()) <= 0L || remainingInterval > (long)this.minInterval) break;
            try {
                Thread.sleep(remainingInterval);
            }
            catch (InterruptedException e) {
                throw new OsmosisRuntimeException("Unable to sleep until next replication iteration.", (Throwable)e);
            }
        }
        while (true) {
            this.obtainNewSnapshot(state);
            if (state.getTxnMaxQueried() != state.getTxnMax() || state.getTxnReady().size() > 0) break;
            systemTimestamp = this.systemTimeLoader.getSystemTime();
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Loaded system time " + systemTimestamp + " from the database.");
            }
            if ((remainingInterval = state.getTimestamp().getTime() + (long)this.maxInterval - systemTimestamp.getTime()) <= 0L || remainingInterval > (long)this.maxInterval) break;
            long sleepInterval = remainingInterval;
            if (sleepInterval > (long)this.minInterval) {
                sleepInterval = this.minInterval;
            }
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException e) {
                throw new OsmosisRuntimeException("Unable to sleep until data becomes available.", (Throwable)e);
            }
        }
        LOG.fine("Processing replication sequence.");
        systemTimestamp = this.systemTimeLoader.getSystemTime();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Loaded system time " + systemTimestamp + " from the database.");
        }
        if (state.getSequenceNumber() == 0L) {
            state.setTimestamp(systemTimestamp);
            state.setTxnMaxQueried(state.getTxnMax());
        } else {
            ReplicationQueryPredicates predicates = this.buildQueryPredicates(state);
            if (predicates.getBottomTransactionId() != predicates.getTopTransactionId()) {
                this.copyChanges(this.source.getHistory(predicates), state);
            }
            if (this.compareTxnIds(state.getTxnMaxQueried(), state.getTxnMax()) >= 0) {
                state.setTimestamp(systemTimestamp);
            }
        }
        this.changeSink.complete();
        LOG.fine("Replication sequence complete.");
    }
}

