/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityDao;
import org.openstreetmap.osmosis.apidb.v0_6.impl.FeatureHistoryPopulator;
import org.openstreetmap.osmosis.apidb.v0_6.impl.RelationMemberRowMapper;
import org.openstreetmap.osmosis.apidb.v0_6.impl.RelationRowMapper;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainerFactory;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainerFactory;
import org.openstreetmap.osmosis.core.database.DbFeatureHistory;
import org.openstreetmap.osmosis.core.database.DbFeatureHistoryRowMapper;
import org.openstreetmap.osmosis.core.database.DbFeatureRowMapper;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.database.DbOrderedFeatureHistoryComparator;
import org.openstreetmap.osmosis.core.database.DbOrderedFeatureRowMapper;
import org.openstreetmap.osmosis.core.database.RelationMemberCollectionLoader;
import org.openstreetmap.osmosis.core.database.RowMapperListener;
import org.openstreetmap.osmosis.core.database.SortingStoreRowMapperListener;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.lifecycle.Closeable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.FileBasedSort;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.StoreReleasingIterator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class RelationDao
extends EntityDao<Relation> {
    private static final Logger LOG = Logger.getLogger(RelationDao.class.getName());
    private static final String[] TYPE_SPECIFIC_FIELD_NAMES = new String[0];

    public RelationDao(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate, "relation");
    }

    @Override
    protected RowMapperListener<CommonEntityData> getEntityRowMapper(RowMapperListener<Relation> entityListener) {
        return new RelationRowMapper(entityListener);
    }

    @Override
    protected String[] getTypeSpecificFieldNames() {
        return TYPE_SPECIFIC_FIELD_NAMES;
    }

    @Override
    protected EntityContainerFactory<Relation> getContainerFactory() {
        return new RelationContainerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableIterator<DbFeatureHistory<DbOrderedFeature<RelationMember>>> getRelationMemberHistory(String selectedEntityStatement, SqlParameterSource parameterSource) {
        try (FileBasedSort sortingStore = new FileBasedSort((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(DbFeatureHistory.class), (Comparator)new DbOrderedFeatureHistoryComparator(), true);){
            String sql = "SELECT rm.relation_id AS id, rm.member_id, rm.member_role, rm.member_type, rm.version, rm.sequence_id FROM relation_members rm INNER JOIN " + selectedEntityStatement + " t ON rm.relation_id = t.relation_id AND rm.version = t.version";
            LOG.log(Level.FINER, "Relation member history query: " + sql);
            SortingStoreRowMapperListener storeListener = new SortingStoreRowMapperListener(sortingStore);
            DbFeatureHistoryRowMapper dbFeatureHistoryRowMapper = new DbFeatureHistoryRowMapper((RowMapperListener)storeListener);
            DbOrderedFeatureRowMapper dbOrderedFeatureRowMapper = new DbOrderedFeatureRowMapper((RowMapperListener)dbFeatureHistoryRowMapper);
            DbFeatureRowMapper dbFeatureRowMapper = new DbFeatureRowMapper((RowMapperListener)dbOrderedFeatureRowMapper);
            RelationMemberRowMapper relationNodeRowMapper = new RelationMemberRowMapper((RowMapperListener<RelationMember>)dbFeatureRowMapper);
            this.getNamedParamJdbcTemplate().query(sql, parameterSource, (RowCallbackHandler)relationNodeRowMapper);
            StoreReleasingIterator resultIterator = new StoreReleasingIterator(sortingStore.iterate(), (Closeable)sortingStore);
            sortingStore = null;
            StoreReleasingIterator storeReleasingIterator = resultIterator;
            return storeReleasingIterator;
        }
    }

    @Override
    protected List<FeatureHistoryPopulator<Relation, ?, ?>> getFeatureHistoryPopulators(String selectedEntityTableName, MapSqlParameterSource parameterSource) {
        ArrayList featurePopulators = new ArrayList();
        ReleasableIterator<DbFeatureHistory<DbOrderedFeature<RelationMember>>> relationNodeIterator = this.getRelationMemberHistory(selectedEntityTableName, (SqlParameterSource)parameterSource);
        featurePopulators.add(new FeatureHistoryPopulator(relationNodeIterator, new RelationMemberCollectionLoader()));
        return featurePopulators;
    }
}

