/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6;

import java.util.Collections;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext2;
import org.openstreetmap.osmosis.apidb.v0_6.ApidbVersionConstants;
import org.openstreetmap.osmosis.apidb.v0_6.impl.AllEntityDao;
import org.openstreetmap.osmosis.apidb.v0_6.impl.SchemaVersionValidator;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.database.DatabaseLocker;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class ApidbCurrentReader
implements RunnableSource {
    private Sink sink;
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;

    public ApidbCurrentReader(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl(DatabaseContext2 dbCtx) {
        try {
            this.sink.initialize(Collections.emptyMap());
            new SchemaVersionValidator(this.loginCredentials, this.preferences).validateVersion(ApidbVersionConstants.SCHEMA_MIGRATIONS);
            AllEntityDao entityDao = new AllEntityDao(dbCtx.getJdbcTemplate());
            this.sink.process((EntityContainer)new BoundContainer(new Bound("Osmosis 0.48.3")));
            try (ReleasableIterator<EntityContainer> reader = entityDao.getCurrent();){
                while (reader.hasNext()) {
                    this.sink.process((EntityContainer)reader.next());
                }
            }
            this.sink.complete();
        }
        finally {
            this.sink.close();
        }
    }

    public void run() {
        try (final DatabaseContext2 dbCtx = new DatabaseContext2(this.loginCredentials);
             final DatabaseLocker locker = new DatabaseLocker(dbCtx.getDataSource(), false);){
            dbCtx.executeWithinTransaction(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                    locker.lockDatabase(((Object)((Object)this)).getClass().getSimpleName());
                    ApidbCurrentReader.this.runImpl(dbCtx);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

