/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;

public class Tag
implements Comparable<Tag>,
Storeable {
    private String key;
    private String value;

    public Tag(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public Tag(StoreReader sr, StoreClassRegister scr) {
        this(sr.readString(), sr.readString());
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        sw.writeString(this.key);
        sw.writeString(this.value);
    }

    @Override
    public int compareTo(Tag tag) {
        int keyResult = this.key.compareTo(tag.key);
        if (keyResult != 0) {
            return keyResult;
        }
        return this.value.compareTo(tag.value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "Tag('" + this.getKey() + "'='" + this.getValue() + "')";
    }
}

