/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.xml.common.BaseElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.MemberTypeParser;
import org.openstreetmap.osmosis.xml.v0_6.impl.RelationMemberListener;
import org.xml.sax.Attributes;

public class RelationMemberElementProcessor
extends BaseElementProcessor {
    private static final String ATTRIBUTE_NAME_ID = "ref";
    private static final String ATTRIBUTE_NAME_TYPE = "type";
    private static final String ATTRIBUTE_NAME_ROLE = "role";
    private RelationMemberListener relationMemberListener;
    private RelationMember relationMember;
    private MemberTypeParser memberTypeParser;

    public RelationMemberElementProcessor(BaseElementProcessor parentProcessor, RelationMemberListener relationMemberListener) {
        super(parentProcessor, true);
        this.relationMemberListener = relationMemberListener;
        this.memberTypeParser = new MemberTypeParser();
    }

    @Override
    public void begin(Attributes attributes) {
        long id = Long.parseLong(attributes.getValue(ATTRIBUTE_NAME_ID));
        EntityType type = this.memberTypeParser.parse(attributes.getValue(ATTRIBUTE_NAME_TYPE));
        String role = attributes.getValue(ATTRIBUTE_NAME_ROLE);
        if (role == null) {
            role = "";
        }
        this.relationMember = new RelationMember(id, type, role);
    }

    @Override
    public void end() {
        this.relationMemberListener.processRelationMember(this.relationMember);
        this.relationMember = null;
    }
}

