/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.extract.apidb.v0_6;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;

public class DatabaseTimeLoader {
    private DatabaseLoginCredentials loginCredentials;

    public DatabaseTimeLoader(DatabaseLoginCredentials loginCredentials) {
        this.loginCredentials = loginCredentials;
    }

    private Date readTimeField(ResultSet timeSet) {
        Date date;
        block8: {
            ResultSet rs = timeSet;
            try {
                timeSet.next();
                Timestamp dbTime = timeSet.getTimestamp("SystemTime");
                date = new Date(((Date)dbTime).getTime());
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to read the time from the database server.", (Throwable)e);
                }
            }
            rs.close();
        }
        return date;
    }

    public Date getDatabaseTime() {
        try (DatabaseContext dbCtx = new DatabaseContext(this.loginCredentials);){
            Date result;
            ResultSet rs = dbCtx.executeQuery("SELECT now() AS SystemTime");
            Date date = result = this.readTimeField(rs);
            return date;
        }
    }
}

