/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.writers;

import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterLib;
import org.apache.jena.sparql.util.FmtUtils;

public class WriterNode {
    private static final int NL = 1;
    private static final int NoNL = -1;
    private static final int NoSP = -2;

    public static void output(IndentedWriter out, Triple triple, SerializationContext naming) {
        WriterLib.startOneLine(out, "triple");
        WriterNode.outputPlain(out, triple, naming);
        WriterLib.finishOneLine(out, "triple");
    }

    public static void outputNoTag(IndentedWriter out, Triple triple, SerializationContext naming) {
        out.print("(");
        WriterNode.outputPlain(out, triple, naming);
        out.print(")");
    }

    public static void outputPlain(IndentedWriter out, Triple triple, SerializationContext naming) {
        WriterNode.output(out, triple.getSubject(), naming);
        out.print(" ");
        WriterNode.output(out, triple.getPredicate(), naming);
        out.print(" ");
        WriterNode.output(out, triple.getObject(), naming);
    }

    public static void output(IndentedWriter out, Quad quad, SerializationContext naming) {
        WriterLib.startOneLine(out, "quad");
        WriterNode.outputPlain(out, quad, naming);
        WriterLib.finishOneLine(out, "quad");
    }

    public static void outputNoTag(IndentedWriter out, Quad quad, SerializationContext naming) {
        out.print("(");
        WriterNode.outputPlain(out, quad, naming);
        out.print(")");
    }

    public static void outputPlain(IndentedWriter out, Quad quad, SerializationContext naming) {
        WriterNode.output(out, quad.getGraph(), naming);
        out.print(" ");
        WriterNode.output(out, quad.getSubject(), naming);
        out.print(" ");
        WriterNode.output(out, quad.getPredicate(), naming);
        out.print(" ");
        WriterNode.output(out, quad.getObject(), naming);
    }

    public static void output(IndentedWriter out, Node node, SerializationContext naming) {
        if (node.isNodeTriple()) {
            Triple t = Node_Triple.triple((Node)node);
            out.print("<< ");
            WriterNode.output(out, t.getSubject(), naming);
            out.print(" ");
            WriterNode.output(out, t.getPredicate(), naming);
            out.print(" ");
            WriterNode.output(out, t.getObject(), naming);
            out.print(" >>");
        } else {
            out.print(FmtUtils.stringForNode(node, naming));
        }
    }

    public static void output(IndentedWriter out, List<Node> nodeList, SerializationContext naming) {
        out.print("(");
        boolean first = true;
        for (Node node : nodeList) {
            if (!first) {
                out.print(" ");
            }
            WriterNode.output(out, node, naming);
            first = false;
        }
        out.print(")");
    }

    public static void outputVars(IndentedWriter out, List<Var> vars, SerializationContext sContext) {
        WriterLib.start(out, "vars", -2);
        for (Var v : vars) {
            out.print(" ?");
            out.print(v.getVarName());
        }
        WriterLib.finish(out, "vars");
    }
}

