/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrdf.http.client.SesameHTTPClient;
import org.openrdf.http.protocol.transaction.operations.AddStatementOperation;
import org.openrdf.http.protocol.transaction.operations.ClearNamespacesOperation;
import org.openrdf.http.protocol.transaction.operations.ClearOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveStatementsOperation;
import org.openrdf.http.protocol.transaction.operations.SPARQLUpdateOperation;
import org.openrdf.http.protocol.transaction.operations.SetNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.TransactionOperation;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.UnknownTransactionStateException;
import org.openrdf.repository.base.RepositoryConnectionBase;
import org.openrdf.repository.http.HTTPBooleanQuery;
import org.openrdf.repository.http.HTTPGraphQuery;
import org.openrdf.repository.http.HTTPRepository;
import org.openrdf.repository.http.HTTPTupleQuery;
import org.openrdf.repository.http.HTTPUpdate;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.StatementCollector;

class HTTPRepositoryConnection
extends RepositoryConnectionBase {
    private List<TransactionOperation> txn = Collections.synchronizedList(new ArrayList());
    private boolean active;
    private Throwable creatorTrace;

    private static boolean debugEnabled() {
        try {
            return System.getProperty("org.openrdf.repository.debug") != null;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public HTTPRepositoryConnection(HTTPRepository repository) {
        super((Repository)repository);
        this.setParserConfig(new ParserConfig());
        this.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        if (HTTPRepositoryConnection.debugEnabled()) {
            this.creatorTrace = new Throwable();
        }
    }

    public HTTPRepository getRepository() {
        return (HTTPRepository)super.getRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.isOpen()) {
                if (this.creatorTrace != null) {
                    this.logger.warn("Closing connection due to garbage collection, connection was create in:", this.creatorTrace);
                }
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void begin() throws RepositoryException {
        this.verifyIsOpen();
        this.verifyNotTxnActive("Connection already has an active transaction");
        this.active = true;
    }

    public Query prepareQuery(QueryLanguage ql, String queryString, String baseURI) {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            String strippedQuery = QueryParserUtil.removeSPARQLQueryProlog((String)queryString).toUpperCase();
            if (strippedQuery.startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, queryString, baseURI);
            }
            if (strippedQuery.startsWith("ASK")) {
                return this.prepareBooleanQuery(ql, queryString, baseURI);
            }
            return this.prepareGraphQuery(ql, queryString, baseURI);
        }
        if (QueryLanguage.SERQL.equals((Object)ql)) {
            String strippedQuery = queryString;
            strippedQuery = strippedQuery.replace('(', ' ');
            if ((strippedQuery = strippedQuery.trim()).toUpperCase().startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, queryString, baseURI);
            }
            return this.prepareGraphQuery(ql, queryString, baseURI);
        }
        throw new UnsupportedOperationException("Operation not supported for query language " + ql);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPTupleQuery(this, ql, queryString, baseURI);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPGraphQuery(this, ql, queryString, baseURI);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPBooleanQuery(this, ql, queryString, baseURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            ArrayList<Resource> contextList = new ArrayList<Resource>();
            TupleQueryResult contextIDs = this.getRepository().getHTTPClient().getContextIDs();
            try {
                while (contextIDs.hasNext()) {
                    BindingSet bindingSet = (BindingSet)contextIDs.next();
                    Value context = bindingSet.getValue("contextID");
                    if (!(context instanceof Resource)) continue;
                    contextList.add((Resource)context);
                }
            }
            finally {
                contextIDs.close();
            }
            return this.createRepositoryResult(contextList);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            StatementCollector collector = new StatementCollector();
            this.exportStatements(subj, pred, obj, includeInferred, (RDFHandler)collector, contexts);
            return this.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void exportStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RDFHandlerException, RepositoryException {
        try {
            this.getRepository().getHTTPClient().getStatements(subj, pred, obj, includeInferred, handler, contexts);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (QueryInterruptedException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public long size(Resource ... contexts) throws RepositoryException {
        try {
            return this.getRepository().getHTTPClient().size(contexts);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RepositoryException {
        List<TransactionOperation> list = this.txn;
        synchronized (list) {
            if (this.txn.size() > 0) {
                try {
                    this.getRepository().getHTTPClient().sendTransaction(this.txn);
                    this.txn.clear();
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            this.active = false;
        }
    }

    public void rollback() {
        this.txn.clear();
        this.active = false;
    }

    public void close() throws RepositoryException {
        if (this.txn.size() > 0) {
            this.logger.warn("Rolling back transaction due to connection close", new Throwable());
            this.rollback();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = file.toURI().toString();
        }
        if (dataFormat == null) {
            dataFormat = Rio.getParserFormatForFileName((String)file.getName());
        }
        FileInputStream in = new FileInputStream(file);
        try {
            this.add(in, baseURI, dataFormat, contexts);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        URLConnection con = url.openConnection();
        if (dataFormat != null) {
            for (String mimeType : dataFormat.getMIMETypes()) {
                con.addRequestProperty("Accept", mimeType);
            }
        } else {
            Set rdfFormats = RDFParserRegistry.getInstance().getKeys();
            List acceptParams = RDFFormat.getAcceptParams((Iterable)rdfFormats, (boolean)true, null);
            for (String acceptParam : acceptParams) {
                con.addRequestProperty("Accept", acceptParam);
            }
        }
        InputStream in = con.getInputStream();
        if (dataFormat == null) {
            String mimeType;
            mimeType = con.getContentType();
            int semiColonIdx = mimeType.indexOf(59);
            if (semiColonIdx >= 0) {
                mimeType = mimeType.substring(0, semiColonIdx);
            }
            if ((dataFormat = Rio.getParserFormatForMIMEType((String)mimeType)) == null) {
                dataFormat = Rio.getParserFormatForFileName((String)url.getPath());
            }
        }
        try {
            this.add(in, baseURI, dataFormat, contexts);
        }
        finally {
            in.close();
        }
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (!this.isActive()) {
            SesameHTTPClient httpClient = this.getRepository().getHTTPClient();
            httpClient.upload(in, baseURI, dataFormat, false, contexts);
        } else {
            super.add(in, baseURI, dataFormat, contexts);
        }
    }

    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (!this.isActive()) {
            SesameHTTPClient httpClient = this.getRepository().getHTTPClient();
            httpClient.upload(reader, baseURI, dataFormat, false, contexts);
        } else {
            super.add(reader, baseURI, dataFormat, contexts);
        }
    }

    protected void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.txn.add((TransactionOperation)new AddStatementOperation(subject, predicate, object, contexts));
    }

    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.txn.add((TransactionOperation)new RemoveStatementsOperation(subject, predicate, object, contexts));
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        this.txn.add((TransactionOperation)new ClearOperation(contexts));
        this.conditionalCommit(localTransaction);
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        boolean localTransaction = this.startLocalTransaction();
        this.txn.add((TransactionOperation)new RemoveNamespaceOperation(prefix));
        this.conditionalCommit(localTransaction);
    }

    public void clearNamespaces() throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        this.txn.add((TransactionOperation)new ClearNamespacesOperation());
        this.conditionalCommit(localTransaction);
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        boolean localTransaction = this.startLocalTransaction();
        this.txn.add((TransactionOperation)new SetNamespaceOperation(prefix, name));
        this.conditionalCommit(localTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        try {
            ArrayList<NamespaceImpl> namespaceList = new ArrayList<NamespaceImpl>();
            TupleQueryResult namespaces = this.getRepository().getHTTPClient().getNamespaces();
            try {
                while (namespaces.hasNext()) {
                    BindingSet bindingSet = (BindingSet)namespaces.next();
                    Value prefix = bindingSet.getValue("prefix");
                    Value namespace = bindingSet.getValue("namespace");
                    if (!(prefix instanceof Literal) || !(namespace instanceof Literal)) continue;
                    String prefixStr = ((Literal)prefix).getLabel();
                    String namespaceStr = ((Literal)namespace).getLabel();
                    namespaceList.add(new NamespaceImpl(prefixStr, namespaceStr));
                }
            }
            finally {
                namespaces.close();
            }
            return this.createRepositoryResult(namespaceList);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String getNamespace(String prefix) throws RepositoryException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        try {
            return this.getRepository().getHTTPClient().getNamespace(prefix);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected <E> RepositoryResult<E> createRepositoryResult(Iterable<? extends E> elements) {
        return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration(elements.iterator()));
    }

    protected void scheduleUpdate(HTTPUpdate update) {
        SPARQLUpdateOperation op = new SPARQLUpdateOperation();
        op.setUpdateString(update.getQueryString());
        op.setBaseURI(update.getBaseURI());
        op.setBindings(update.getBindingsArray());
        op.setIncludeInferred(update.getIncludeInferred());
        op.setDataset(update.getDataset());
        this.txn.add((TransactionOperation)op);
    }

    public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
        return new HTTPUpdate(this, ql, update, baseURI);
    }

    protected void verifyIsOpen() throws RepositoryException {
        if (!this.isOpen()) {
            throw new RepositoryException("Connection has been closed");
        }
    }

    protected void verifyTxnActive() throws RepositoryException {
        if (!this.isActive()) {
            throw new RepositoryException("Connection does not have an active transaction");
        }
    }

    protected void verifyNotTxnActive(String msg) throws RepositoryException {
        if (this.isActive()) {
            throw new RepositoryException(msg);
        }
    }

    public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
        return this.active;
    }
}

