/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.rexster.extension.ExtensionAllowed;
import com.tinkerpop.rexster.extension.ExtensionApi;
import com.tinkerpop.rexster.extension.ExtensionApiBehavior;
import com.tinkerpop.rexster.extension.ExtensionConfiguration;
import com.tinkerpop.rexster.extension.ExtensionDefinition;
import com.tinkerpop.rexster.extension.ExtensionDescriptor;
import com.tinkerpop.rexster.extension.ExtensionNaming;
import com.tinkerpop.rexster.extension.ExtensionPoint;
import com.tinkerpop.rexster.extension.ExtensionRequestParameter;
import com.tinkerpop.rexster.extension.ExtensionSegmentSet;
import com.tinkerpop.rexster.extension.RexsterExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class RexsterApplicationGraph {
    private static final Logger logger = Logger.getLogger(RexsterApplicationGraph.class);
    private static final String QUERY_STRING_PARAMETER_NAME = "name";
    private static final String QUERY_STRING_PARAMETER_DESCRIPTION = "description";
    private final Graph graph;
    private final String graphName;
    private Set<ExtensionAllowed> extensionAllowables;
    private Set<ExtensionConfiguration> extensionConfigurations;
    private static final ServiceLoader<? extends RexsterExtension> extensions = ServiceLoader.load(RexsterExtension.class);
    private final Map<ExtensionPoint, List<HashMap<String, Object>>> hypermediaCache = new HashMap<ExtensionPoint, List<HashMap<String, Object>>>();
    private final Map<ExtensionSegmentSet, Boolean> extensionAllowedCache = new HashMap<ExtensionSegmentSet, Boolean>();

    public RexsterApplicationGraph(String graphName, Graph graph) {
        this(graphName, graph, null);
    }

    public RexsterApplicationGraph(String graphName, Graph graph, HierarchicalConfiguration graphConfig) {
        this(graphName, graph, graphConfig == null ? null : graphConfig.getList("extensions.allows.allow"), graphConfig == null ? null : graphConfig.configurationsAt("extensions.extension"));
    }

    public RexsterApplicationGraph(String graphName, Graph graph, List<String> allowableNamespaces, List<HierarchicalConfiguration> extensionConfigurations) {
        this.graphName = graphName;
        this.graph = graph;
        this.loadAllowableExtensions(allowableNamespaces);
        this.loadExtensionsConfigurations(extensionConfigurations);
    }

    public String getGraphName() {
        return this.graphName;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Graph getUnwrappedGraph() {
        return RexsterApplicationGraph.unwrapGraph(this.graph);
    }

    public TransactionalGraph tryGetTransactionalGraph() {
        TransactionalGraph transactionalGraph = null;
        if (this.graph.getFeatures().supportsTransactions.booleanValue() && this.graph instanceof TransactionalGraph) {
            transactionalGraph = (TransactionalGraph)this.graph;
        }
        return transactionalGraph;
    }

    public boolean isTransactionalGraph() {
        TransactionalGraph transactionalGraph = this.tryGetTransactionalGraph();
        return transactionalGraph != null;
    }

    public void tryCommit() {
        TransactionalGraph transactionalGraph = this.tryGetTransactionalGraph();
        if (transactionalGraph != null) {
            transactionalGraph.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
        }
    }

    public void tryRollback() {
        TransactionalGraph transactionalGraph = this.tryGetTransactionalGraph();
        if (transactionalGraph != null) {
            transactionalGraph.stopTransaction(TransactionalGraph.Conclusion.FAILURE);
        }
    }

    public boolean isExtensionAllowed(ExtensionSegmentSet extensionSegmentSet) {
        boolean allowed = false;
        if (!this.extensionAllowedCache.containsKey(extensionSegmentSet)) {
            for (ExtensionAllowed extensionAllowed : this.extensionAllowables) {
                if (!extensionAllowed.isExtensionAllowed(extensionSegmentSet)) continue;
                allowed = true;
                break;
            }
            this.extensionAllowedCache.put(extensionSegmentSet, allowed);
        } else {
            allowed = this.extensionAllowedCache.get(extensionSegmentSet);
        }
        return allowed;
    }

    public ExtensionConfiguration findExtensionConfiguration(String namespace, String extensionName) {
        ExtensionConfiguration extensionConfigurationFound = null;
        if (this.extensionConfigurations != null) {
            for (ExtensionConfiguration extensionConfiguration : this.extensionConfigurations) {
                if (!extensionConfiguration.getExtensionName().equals(extensionName) || !extensionConfiguration.getNamespace().equals(namespace)) continue;
                extensionConfigurationFound = extensionConfiguration;
                break;
            }
        }
        return extensionConfigurationFound;
    }

    void loadExtensionsConfigurations(List<HierarchicalConfiguration> extensionConfigurations) {
        this.extensionConfigurations = new HashSet<ExtensionConfiguration>();
        if (extensionConfigurations != null) {
            for (HierarchicalConfiguration configuration : extensionConfigurations) {
                String namespace = configuration.getString("namespace", "");
                String name = configuration.getString(QUERY_STRING_PARAMETER_NAME, "");
                SubnodeConfiguration extensionConfig = configuration.configurationAt("configuration");
                if (!namespace.isEmpty() && !name.isEmpty() && extensionConfig != null) {
                    this.extensionConfigurations.add(new ExtensionConfiguration(namespace, name, (HierarchicalConfiguration)extensionConfig));
                    continue;
                }
                logger.warn((Object)("Graph [" + this.graphName + "] - Extension [" + namespace + ":" + name + "] does not have a valid configuration.  Please check rexster.xml"));
            }
            this.initializeExtensionHypermediaCache();
        }
    }

    void loadAllowableExtensions(List allowableNamespaces) {
        this.extensionAllowables = new HashSet<ExtensionAllowed>();
        if (allowableNamespaces != null) {
            for (int ix = 0; ix < allowableNamespaces.size(); ++ix) {
                String namespace = allowableNamespaces.get(ix).toString();
                try {
                    this.getExtensionAllowables().add(new ExtensionAllowed(namespace));
                    logger.info((Object)("Graph [" + this.graphName + "] - configured with allowable namespace [" + namespace + "]"));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    logger.warn((Object)("Graph [" + this.graphName + "] - Extension defined with an invalid namespace: " + namespace + ".  It will not be configured."));
                }
            }
        }
    }

    public Set<ExtensionAllowed> getExtensionAllowables() {
        return this.extensionAllowables;
    }

    public Set<ExtensionConfiguration> getExtensionConfigurations() {
        return this.extensionConfigurations;
    }

    static Graph unwrapGraph(Graph g) {
        return g instanceof WrapperGraph ? RexsterApplicationGraph.unwrapGraph(((WrapperGraph)g).getBaseGraph()) : g;
    }

    public String toString() {
        return this.graphName + "-" + this.graph.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RexsterApplicationGraph that = (RexsterApplicationGraph)o;
        if (!this.graphName.equals(that.graphName)) {
            return false;
        }
        if (!this.graph.getClass().equals(that.graph.getClass())) {
            return false;
        }
        for (ExtensionAllowed extensionAllowed : this.extensionAllowables) {
            if (that.getExtensionAllowables().contains(extensionAllowed)) continue;
            return false;
        }
        for (ExtensionConfiguration configuration : this.extensionConfigurations) {
            if (that.getExtensionConfigurations().contains(configuration)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.graph.hashCode();
        result = 31 * result + this.graphName.hashCode();
        result = 31 * result + this.extensionAllowables.hashCode();
        result = 31 * result + this.extensionConfigurations.hashCode();
        return result;
    }

    protected JSONArray getExtensionHypermedia(ExtensionPoint extensionPoint, String baseUri) {
        List<HashMap<String, Object>> hypermediaLinks = this.hypermediaCache.containsKey((Object)extensionPoint) ? this.hypermediaCache.get((Object)extensionPoint) : this.createHyperMediaLinks(extensionPoint);
        return this.getComposedLinks(baseUri, hypermediaLinks);
    }

    private List<HashMap<String, Object>> createHyperMediaLinks(ExtensionPoint extensionPoint) {
        ArrayList<HashMap<String, Object>> hypermediaLinks = new ArrayList<HashMap<String, Object>>();
        for (RexsterExtension rexsterExtension : extensions) {
            Class<?> clazz = rexsterExtension.getClass();
            ExtensionNaming extensionNaming = clazz.getAnnotation(ExtensionNaming.class);
            String currentExtensionNamespace = "g";
            String currentExtensionName = clazz.getName();
            if (extensionNaming != null) {
                if (extensionNaming.name() != null && !extensionNaming.name().isEmpty()) {
                    currentExtensionName = extensionNaming.name();
                }
                if (extensionNaming.namespace() != null && !extensionNaming.namespace().isEmpty()) {
                    currentExtensionNamespace = extensionNaming.namespace();
                }
            }
            String currentNamespaceAndName = this.makeExtensionName(currentExtensionNamespace, currentExtensionName);
            ExtensionSegmentSet extensionSegmentSet = new ExtensionSegmentSet(currentExtensionNamespace, currentExtensionName);
            if (!this.isExtensionAllowed(extensionSegmentSet)) continue;
            ExtensionConfiguration extensionConfig = this.findExtensionConfiguration(currentExtensionNamespace, currentExtensionName);
            RexsterExtension rexsterExtension2 = null;
            try {
                rexsterExtension2 = (RexsterExtension)clazz.newInstance();
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("Failed extension configuration check for %s on graph %s", currentNamespaceAndName, this.graphName));
            }
            if (rexsterExtension2 == null) continue;
            if (rexsterExtension2.isConfigurationValid(extensionConfig)) {
                Method[] methods;
                for (Method method : methods = clazz.getMethods()) {
                    JSONArray queryStringParameters;
                    ExtensionDescriptor descriptor = method.getAnnotation(ExtensionDescriptor.class);
                    ExtensionDefinition definition = method.getAnnotation(ExtensionDefinition.class);
                    if (definition == null || definition.extensionPoint() != extensionPoint) continue;
                    String href = currentExtensionNamespace + "/" + currentExtensionName;
                    if (!definition.path().isEmpty()) {
                        href = href + "/" + definition.path();
                    }
                    HashMap<String, String> hypermediaLink = new HashMap<String, String>();
                    hypermediaLink.put("href", href);
                    hypermediaLink.put("op", definition.method().name());
                    hypermediaLink.put("namespace", currentExtensionNamespace);
                    hypermediaLink.put(QUERY_STRING_PARAMETER_NAME, currentExtensionName);
                    String path = definition.path();
                    if (path != null && !path.isEmpty()) {
                        hypermediaLink.put("path", path);
                        hypermediaLink.put("title", currentNamespaceAndName + "-" + path);
                    } else {
                        hypermediaLink.put("title", currentNamespaceAndName);
                    }
                    if (descriptor != null) {
                        hypermediaLink.put(QUERY_STRING_PARAMETER_DESCRIPTION, descriptor.description());
                    }
                    if ((queryStringParameters = this.buildQueryStringParameters(method, descriptor)).length() > 0) {
                        hypermediaLink.put("parameters", (String)queryStringParameters);
                    }
                    hypermediaLinks.add(hypermediaLink);
                }
                continue;
            }
            logger.warn((Object)String.format("An extension [%s] does not have a valid configuration.  Check rexster.xml and ensure that the configuration section matches what the extension expects.", currentNamespaceAndName));
        }
        if (hypermediaLinks.size() == 0) {
            this.hypermediaCache.put(extensionPoint, null);
        } else {
            this.hypermediaCache.put(extensionPoint, hypermediaLinks);
        }
        return hypermediaLinks;
    }

    private String makeExtensionName(String extensionNamespace, String extensionName) {
        return String.format("%s:%s", extensionNamespace, extensionName);
    }

    private JSONArray buildQueryStringParameters(Method method, ExtensionDescriptor descriptor) {
        JSONArray queryStringParameters = new JSONArray();
        if (descriptor != null && (descriptor.apiBehavior() == ExtensionApiBehavior.DEFAULT || descriptor.apiBehavior() == ExtensionApiBehavior.EXTENSION_DESCRIPTOR_ONLY)) {
            for (final ExtensionApi extensionApi : descriptor.api()) {
                queryStringParameters.put((Map)new HashMap<String, String>(){
                    {
                        this.put(RexsterApplicationGraph.QUERY_STRING_PARAMETER_NAME, extensionApi.parameterName());
                        this.put(RexsterApplicationGraph.QUERY_STRING_PARAMETER_DESCRIPTION, extensionApi.description());
                    }
                });
            }
        }
        if (descriptor != null && (descriptor.apiBehavior() == ExtensionApiBehavior.DEFAULT || descriptor.apiBehavior() == ExtensionApiBehavior.EXTENSION_PARAMETER_ONLY)) {
            Annotation[][] parametersAnnotationSets;
            Annotation[][] arr$ = parametersAnnotationSets = method.getParameterAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] parameterAnnotationSet;
                for (Annotation annotation : parameterAnnotationSet = arr$[i$]) {
                    if (!(annotation instanceof ExtensionRequestParameter)) continue;
                    final ExtensionRequestParameter extensionRequestParameter = (ExtensionRequestParameter)annotation;
                    queryStringParameters.put((Map)new HashMap<String, String>(){
                        {
                            this.put(RexsterApplicationGraph.QUERY_STRING_PARAMETER_NAME, extensionRequestParameter.name());
                            this.put(RexsterApplicationGraph.QUERY_STRING_PARAMETER_DESCRIPTION, extensionRequestParameter.description());
                        }
                    });
                }
            }
        }
        return queryStringParameters;
    }

    private JSONArray getComposedLinks(String baseUri, List<HashMap<String, Object>> hypermediaLinks) {
        JSONArray composedLinks = null;
        if (hypermediaLinks != null) {
            composedLinks = new JSONArray();
            for (Map map : hypermediaLinks) {
                HashMap link = new HashMap();
                for (Map.Entry linkEntry : map.entrySet()) {
                    if (((String)linkEntry.getKey()).equals("href")) {
                        link.put(linkEntry.getKey(), baseUri + linkEntry.getValue());
                        continue;
                    }
                    link.put(linkEntry.getKey(), (String)linkEntry.getValue());
                }
                composedLinks.put((Object)new JSONObject(link));
            }
        }
        return composedLinks;
    }

    private void initializeExtensionHypermediaCache() {
        this.getExtensionHypermedia(ExtensionPoint.GRAPH, "");
        this.getExtensionHypermedia(ExtensionPoint.VERTEX, "");
        this.getExtensionHypermedia(ExtensionPoint.EDGE, "");
    }
}

