/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.cache.HardReferenceQueue;
import com.bigdata.cache.IConcurrentWeakValueCache;
import com.bigdata.cache.IHardReferenceQueue;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ConcurrentWeakValueCache<K, V>
implements IConcurrentWeakValueCache<K, V> {
    protected static final transient Logger log = Logger.getLogger(ConcurrentWeakValueCache.class);
    protected static final transient boolean INFO = log.isInfoEnabled();
    protected static final transient boolean DEBUG = log.isDebugEnabled();
    private final ConcurrentHashMap<K, WeakReference<V>> map;
    private final IHardReferenceQueue<V> queue;
    private final ReferenceQueue<V> referenceQueue;

    public boolean isRemoveClearedReferences() {
        return this.referenceQueue != null;
    }

    @Override
    public int size() {
        this.removeClearedEntries();
        return this.map.size();
    }

    @Override
    public int capacity() {
        if (this.queue == null) {
            return 0;
        }
        return this.queue.capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.queue != null) {
            IHardReferenceQueue<V> iHardReferenceQueue = this.queue;
            synchronized (iHardReferenceQueue) {
                this.queue.clear(true);
                this.map.clear();
            }
        }
        this.removeClearedEntries();
    }

    public ConcurrentWeakValueCache() {
        this(16);
    }

    public ConcurrentWeakValueCache(int queueCapacity) {
        this(queueCapacity, 0.75f, 16);
    }

    public ConcurrentWeakValueCache(int queueCapacity, float loadFactor, int concurrencyLevel) {
        this(queueCapacity, loadFactor, concurrencyLevel, true);
    }

    public ConcurrentWeakValueCache(int queueCapacity, float loadFactor, int concurrencyLevel, boolean removeClearedReferences) {
        this(queueCapacity == 0 ? null : new HardReferenceQueue(null, queueCapacity), loadFactor, concurrencyLevel, removeClearedReferences);
    }

    public ConcurrentWeakValueCache(IHardReferenceQueue<V> queue, float loadFactor, int concurrencyLevel, boolean removeClearedReferences) {
        this(queue, queue == null ? 16 : Math.max(16, queue.capacity() / 2), loadFactor, concurrencyLevel, removeClearedReferences);
    }

    public ConcurrentWeakValueCache(IHardReferenceQueue<V> queue, int initialCapacity, float loadFactor, int concurrencyLevel, boolean removeClearedReferences) {
        this.queue = queue;
        this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        this.referenceQueue = removeClearedReferences ? new ReferenceQueue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K k) {
        Object v;
        WeakReference<V> ref = this.map.get(k);
        if (ref != null && (v = ref.get()) != null) {
            if (this.queue != null) {
                IHardReferenceQueue<V> iHardReferenceQueue = this.queue;
                synchronized (iHardReferenceQueue) {
                    this.queue.add(v);
                }
            }
            return (V)v;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K k) {
        Object v;
        WeakReference<V> ref = this.map.get(k);
        if (ref != null && (v = ref.get()) != null) {
            if (this.queue != null) {
                IHardReferenceQueue<V> iHardReferenceQueue = this.queue;
                synchronized (iHardReferenceQueue) {
                    this.queue.add(v);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        try {
            IHardReferenceQueue<V> iHardReferenceQueue;
            Object oldVal;
            WeakReference<V> ref = this.newWeakRef(k, v, this.referenceQueue);
            WeakReference<V> oldRef = this.map.put(k, ref);
            Object v0 = oldVal = oldRef == null ? null : oldRef.get();
            if (this.queue != null) {
                iHardReferenceQueue = this.queue;
                synchronized (iHardReferenceQueue) {
                    if (this.queue.add(v) && DEBUG) {
                        log.debug((Object)("put: key=" + k + ", val=" + v));
                    }
                }
            }
            this.didUpdate(k, ref, oldRef);
            iHardReferenceQueue = oldVal;
            return (V)iHardReferenceQueue;
        }
        finally {
            this.removeClearedEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K k, V v) {
        try {
            V oldVal;
            WeakReference<V> ref = this.newWeakRef(k, v, this.referenceQueue);
            WeakReference<V> oldRef = this.map.putIfAbsent(k, ref);
            V v2 = oldVal = oldRef == null ? null : (V)oldRef.get();
            if (oldRef != null && oldVal == null) {
                if (this.map.replace(k, oldRef, ref)) {
                    IHardReferenceQueue<V> iHardReferenceQueue;
                    if (this.queue != null) {
                        iHardReferenceQueue = this.queue;
                        synchronized (iHardReferenceQueue) {
                            if (this.queue.add(v) && DEBUG) {
                                log.debug((Object)("put: key=" + k + ", val=" + v));
                            }
                        }
                    }
                    this.didUpdate(k, ref, oldRef);
                    iHardReferenceQueue = null;
                    return (V)iHardReferenceQueue;
                }
                V v3 = this.putIfAbsent(k, v);
                return v3;
            }
            if (oldVal == null) {
                IHardReferenceQueue<V> iHardReferenceQueue;
                if (this.queue != null) {
                    iHardReferenceQueue = this.queue;
                    synchronized (iHardReferenceQueue) {
                        if (this.queue.add(v) && DEBUG) {
                            log.debug((Object)("put: key=" + k + ", val=" + v));
                        }
                    }
                }
                this.didUpdate(k, ref, null);
                iHardReferenceQueue = null;
                return (V)iHardReferenceQueue;
            }
            V v4 = oldVal;
            return v4;
        }
        finally {
            this.removeClearedEntries();
        }
    }

    protected void didUpdate(K k, WeakReference<V> newRef, WeakReference<V> oldRef) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K k) {
        try {
            WeakReference<V> ref = this.removeMapEntry(k);
            if (ref != null) {
                Object t = ref.get();
                return (V)t;
            }
            V v = null;
            return v;
        }
        finally {
            this.removeClearedEntries();
        }
    }

    protected void removeClearedEntries() {
        if (this.referenceQueue == null) {
            return;
        }
        int counter = 0;
        Reference<V> ref = this.referenceQueue.poll();
        while (ref != null) {
            Object k = ((WeakRef)ref).k;
            if (this.map.get(k) == ref) {
                if (DEBUG) {
                    log.debug((Object)("Removing cleared reference: key=" + k));
                }
                this.removeMapEntry(k);
                ++counter;
            }
            ref = this.referenceQueue.poll();
        }
        if (counter > 1 && INFO) {
            log.info((Object)("Removed " + counter + " cleared references"));
        }
    }

    protected WeakReference<V> removeMapEntry(K k) {
        return this.map.remove(k);
    }

    @Override
    public Iterator<WeakReference<V>> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Iterator<Map.Entry<K, WeakReference<V>>> entryIterator() {
        return this.map.entrySet().iterator();
    }

    protected WeakReference<V> newWeakRef(K k, V v, ReferenceQueue<V> referenceQueue) {
        if (referenceQueue == null) {
            return new WeakReference<V>(v);
        }
        return new WeakRef<K, V>(k, v, referenceQueue);
    }

    protected static class WeakRef<K, V>
    extends WeakReference<V> {
        private final K k;

        public WeakRef(K k, V v, ReferenceQueue<V> queue) {
            super(v, queue);
            this.k = k;
        }

        public String toString() {
            return super.toString() + "{key=" + this.k + ",val=" + this.get() + "}";
        }
    }
}

