/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.util;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MatrixConverter {
    private Map<String, List<Object>> map = new HashMap<String, List<Object>>();

    public void putColumn(String key, List<Object> list) {
        this.map.put(key, list);
    }

    public String toJson() {
        return new Gson().toJson(this.map);
    }

    public Map<String, List<Object>> fromJson(String s) {
        this.map = (Map)new Gson().fromJson(s, HashMap.class);
        return this.map;
    }

    public List<Object> getList(String key) {
        return this.map.get(key);
    }

    public static Map<String, List<String>> fromCsv(String s) {
        HashMap<String, List<String>> smap = new HashMap<String, List<String>>();
        String sClean = s.replace("\r", "");
        StringTokenizer tokenizer = new StringTokenizer(sClean, "\n");
        List<String> columnNames = MatrixConverter.fromCsvRow(tokenizer.nextToken());
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        while (tokenizer.hasMoreTokens()) {
            rows.add(MatrixConverter.fromCsvRow(tokenizer.nextToken()));
        }
        for (int columnIndex = 0; columnIndex < columnNames.size(); ++columnIndex) {
            ArrayList column = new ArrayList();
            for (List list : rows) {
                column.add(list.get(columnIndex));
            }
            smap.put(columnNames.get(columnIndex), column);
        }
        return smap;
    }

    private static List<String> fromCsvRow(String s) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public static String fromArraytoCsv(List<String[]> rows) {
        StringBuffer b = new StringBuffer();
        for (String[] current : rows) {
            MatrixConverter.appendRow(b, current);
        }
        return b.toString();
    }

    private static void appendRow(StringBuffer b, String[] row) {
        int length = row.length;
        for (int i = 0; i < length; ++i) {
            b.append(row[i]);
            if (i < length - 1) {
                b.append(",");
                continue;
            }
            b.append("\r\n");
        }
    }

    public static List<String[]> fromCsvToArray(String s) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        String sClean = s.replace("\r", "");
        StringTokenizer tokenizer = new StringTokenizer(sClean, "\n");
        while (tokenizer.hasMoreTokens()) {
            String[] row = tokenizer.nextToken().split(",");
            result.add(row);
        }
        return result;
    }

    public static String[] asArray(List<String> l) {
        String[] a = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            a[i] = l.get(i);
        }
        return a;
    }
}

