/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.scenario;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Controller;
import uk.ac.cam.cares.jps.base.discovery.AgentCaller;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.scenario.JPSContext;

@Controller
public abstract class JPSHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 3507827296966247195L;
    protected Logger logger;
    private static final String GET_AGENT_INPUT_PARAMS_KEY = "query";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) {
        System.out.println("HANDLING REQUEST 1: ");
        try {
            JSONObject reqBody = JPSHttpServlet.enableScenario(request);
            System.out.println("HANDLING REQUEST 2: ");
            System.out.println("REQ_BODY: " + reqBody.toString());
            if (request.getMethod().equals("GET")) {
                System.out.println("HANDLING REQUEST 3: ");
                this.doGetJPS(request, response);
            } else if (request.getMethod().equals("POST")) {
                this.doPostJPS(request, response, reqBody);
            } else if (request.getMethod().equals("PUT")) {
                this.doPutJPS(request, response, reqBody);
            }
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        finally {
            JPSHttpServlet.disableScenario();
        }
    }

    protected void doGetJPS(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("DO GET JPS: ");
        this.doHttpJPS(request, response);
    }

    protected void doPostJPS(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doHttpJPS(request, response);
    }

    protected void doPostJPS(HttpServletRequest request, HttpServletResponse response, JSONObject reqBody) throws ServletException, IOException {
        this.doHttpJPS(request, response, reqBody);
    }

    protected void doPutJPS(HttpServletRequest request, HttpServletResponse response, JSONObject reqBody) throws ServletException, IOException {
        this.doHttpJPS(request, response, reqBody);
    }

    protected void doHttpJPS(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.setLogger();
        try {
            String responseBody = this.getResponseBody(request);
            response.getWriter().write(responseBody);
        }
        catch (BadRequestException e) {
            this.logger.error(e.getMessage());
            response.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (JPSRuntimeException e) {
            this.logger.error(e.getMessage());
            response.setStatus(Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
        }
    }

    protected void doHttpJPS(HttpServletRequest request, HttpServletResponse response, JSONObject reqBody) throws IOException, ServletException {
        this.setLogger();
        try {
            String responseBody = this.getResponseBody(request, reqBody);
            response.getWriter().write(responseBody);
        }
        catch (BadRequestException e) {
            this.logger.error(e.getMessage());
            response.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
        }
    }

    protected void setLogger() {
        this.logger = LogManager.getLogger(JPSHttpServlet.class);
    }

    protected String getResponseBody(HttpServletRequest request) {
        System.out.println("DO GET RESPONSE BODY: 1 ");
        JSONObject requestParams = AgentCaller.readJsonParameter(request);
        requestParams.put("path", (Object)request.getPathInfo());
        System.out.println("DO GET RESPONSE BODY: 2 ");
        JSONObject responseParams = this.processRequestParameters(requestParams);
        if (responseParams.isEmpty()) {
            responseParams = this.processRequestParameters(requestParams, request);
        }
        return responseParams.toString();
    }

    protected String getResponseBody(HttpServletRequest request, JSONObject requestParams) {
        requestParams.put("path", (Object)request.getPathInfo());
        JSONObject responseParams = this.processRequestParameters(requestParams);
        if (responseParams.isEmpty()) {
            responseParams = this.processRequestParameters(requestParams, request);
        }
        return responseParams.toString();
    }

    protected JSONObject processRequestParameters(JSONObject requestParams) {
        JSONObject responseParams = new JSONObject();
        return responseParams;
    }

    protected JSONObject processRequestParameters(JSONObject requestParams, HttpServletRequest request) {
        JSONObject responseParams = new JSONObject();
        return responseParams;
    }

    protected String execute(String path, String jsonInput, String method) {
        String result;
        System.out.println("execute for path=" + path + ", json=" + jsonInput);
        switch (method) {
            case "GET": {
                result = AgentCaller.executeGet(path, GET_AGENT_INPUT_PARAMS_KEY, jsonInput);
                break;
            }
            case "POST": {
                result = AgentCaller.executePost(path, jsonInput);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + method);
            }
        }
        System.out.println("execution result=" + result);
        return result;
    }

    protected String execute(String path, String jsonInput) {
        return this.execute(path, jsonInput, "GET");
    }

    public static JSONObject enableScenario(HttpServletRequest request) {
        System.out.println("ENABLING SCENARIO 1:");
        JSONObject jo = AgentCaller.readJsonParameter(request);
        if (JPSContext.getScenarioUrl(jo) != null) {
            String scenarioUrl = JPSContext.getScenarioUrl(jo);
            JPSContext.putScenarioUrl(scenarioUrl);
        }
        if (JPSContext.getUsecaseUrl(jo) != null) {
            String usecaseUrl = JPSContext.getUsecaseUrl(jo);
            JPSContext.putUsecaseUrl(usecaseUrl);
        }
        return jo;
    }

    public static void enableScenario(String scenarioUrl) {
        JPSContext.putScenarioUrl(scenarioUrl);
    }

    public static void enableScenario(String scenarioUrl, String usecaseUrl) {
        JPSContext.putScenarioUrl(scenarioUrl);
        JPSContext.putUsecaseUrl(usecaseUrl);
    }

    public static void disableScenario() {
        JPSContext.removeScenarioUrl();
        JPSContext.removeUsecaseUrl();
    }
}

