/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.net.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.cares.jps.base.config.AgentLocator;
import uk.ac.cam.cares.jps.base.config.KeyValueManager;
import uk.ac.cam.cares.jps.base.discovery.AgentCaller;
import uk.ac.cam.cares.jps.base.scenario.JPSContext;

public class ResourcePathConverter {
    private static final Logger LOGGER = LogManager.getLogger(ResourcePathConverter.class);
    private static ResourcePathConverter instance = null;

    public static synchronized ResourcePathConverter getInstance() {
        if (instance == null) {
            instance = new ResourcePathConverter();
        }
        return instance;
    }

    public static String convert(String path) {
        if (!AgentLocator.isJPSRunningForTest()) {
            LOGGER.info(path);
            return path;
        }
        String scenarioUrl = JPSContext.getScenarioUrl();
        if (scenarioUrl != null) {
            LOGGER.info("scenarioURL = " + scenarioUrl + path);
            return path;
        }
        String address = KeyValueManager.getServerAddress();
        String converted = path;
        LOGGER.info("IT GOES HERE IN RPC,CONVERTED= " + converted);
        if (!path.contains("http://www.theworldavatar.com/ontology")) {
            if (path.contains("http://www.theworldavatar.com")) {
                converted = path.replace("http://www.theworldavatar.com", address);
                LOGGER.info("converted resource path " + path + " to " + converted);
            } else if (path.contains("http://www.jparksimulator.com")) {
                converted = path.replace("http://www.jparksimulator.com", address);
                LOGGER.info("convert(): converted resource path " + path + " to " + converted);
            }
        }
        return converted;
    }

    public static String convertToLocalPath(String path) {
        URI uri = AgentCaller.createURI(path, new String[0]);
        String root = KeyValueManager.get("absdir.root");
        String converted = root + uri.getPath();
        LOGGER.info("convertToLocalPath(): converted resource path " + path + " to " + converted);
        return converted;
    }
}

