/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.email;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.discovery.AgentCaller;

public class EmailSender {
    private static final String DEFAULT_AGENT_URL = "http://kg.cmclinnovations.com/agents/email-agent";
    private final Properties metadata = new Properties();
    private String emailAgentURL;
    private boolean isAgentReachable = false;

    public EmailSender() {
        this.determineAgentLocation();
        this.isAgentReachable = this.isReachable();
        this.gatherMetaData();
    }

    public Optional<Path> sendEmail(String subject, String body) throws Exception {
        StringBuilder strBuilder = new StringBuilder(body);
        strBuilder.append("<br><br>");
        strBuilder.append("The following meta-data was gathered from the machine triggering this notification:");
        strBuilder.append("<br>");
        for (Object key : this.metadata.keySet()) {
            strBuilder.append("&#9;").append(key).append(": ").append(this.metadata.get(key));
            strBuilder.append("<br>");
        }
        if (!this.isAgentReachable) {
            System.out.println("INFO: Not running at CMCL/EmailAgent is unavailable, will write email to file instead.");
            return Optional.of(this.writeToFile(subject, strBuilder.toString()));
        }
        try {
            this.makeRequest(subject, strBuilder.toString());
            return Optional.empty();
        }
        catch (Exception exception) {
            return Optional.of(this.writeToFile(subject, strBuilder.toString()));
        }
    }

    private void makeRequest(String subject, String body) throws Exception {
        JSONObject request = new JSONObject();
        request.put("subject", (Object)subject);
        request.put("body", (Object)body);
        try {
            String result = AgentCaller.executeGetWithURLAndJSON(this.emailAgentURL, request.toString());
            if (result.contains("200") && result.contains("success")) {
                System.out.println("INFO: EmailAgent reports successful request, will send email.");
            } else {
                JSONObject resultJSON = new JSONObject(result);
                System.out.println("ERROR: EmailAgent reports issues, cannot send email!");
                System.out.println("ERROR:   Status: " + resultJSON.get("status"));
                System.out.println("ERROR:   Description: " + resultJSON.get("description"));
            }
        }
        catch (Exception exception) {
            System.out.println("WARN: Could not contact remote EmailAgent instance, will write to file instead.");
        }
    }

    private Path writeToFile(String subject, String body) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSSS");
        String datetime = dateFormat.format(new Date());
        String fileName = "EmailSender_" + datetime + ".log";
        Path logFile = Paths.get(fileName, new String[0]);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(logFile.toFile()));){
            writer.append("Subject: ").append(subject);
            writer.append("\n");
            writer.append("Body:\n");
            writer.append(body);
        }
        System.out.println("INFO: Email content written to file at: " + logFile.toAbsolutePath());
        return logFile;
    }

    private boolean isReachable() {
        try {
            String result = AgentCaller.executeGetWithURLAndJSON(this.emailAgentURL, "{ \"ping\": \"true\" }");
            if (result.contains("200")) {
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("WARN: Could not contact remote EmailAgent instance, will log to file instead.");
        }
        return false;
    }

    private void determineAgentLocation() {
        String variable = System.getenv("EMAIL_AGENT_URL");
        if (variable == null || variable.trim().isEmpty()) {
            this.emailAgentURL = DEFAULT_AGENT_URL;
            System.out.println("WARN: Could not find EMAIL_AGENT_URL variable, using fallback URL: " + this.emailAgentURL);
        } else {
            this.emailAgentURL = variable;
            System.out.println("INFO: Found EMAIL_AGENT_URL variable, remote location is: " + this.emailAgentURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherMetaData() {
        String hostname = "Unknown";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException exception) {
            System.out.println("WARN: Could not determine host name.");
        }
        finally {
            this.metadata.put("Hostname", hostname);
        }
        String localIP = "Unknown";
        try {
            localIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException exception) {
            System.out.println("WARN: Could not determine local IP address.");
        }
        finally {
            this.metadata.put("Local IP Address", localIP);
        }
        String publicIP = "Unknown";
        try {
            publicIP = this.getPublicIP();
        }
        catch (Exception exception) {
            System.out.println("WARN: Could not determine public IP address.");
        }
        finally {
            this.metadata.put("Public IP Address", publicIP);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
        String datetime = dateFormat.format(new Date());
        this.metadata.put("Submission Time", datetime);
    }

    private String getPublicIP() throws Exception {
        URL url = new URL("http://checkip.amazonaws.com");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String string = reader.readLine();
            return string;
        }
    }
}

