/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RioUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RioUtils.class);

    private RioUtils() {
    }

    @Nullable
    public static Statement tripleAsStatement(RDFTriple triple) {
        return RioUtils.tripleAsStatements(triple, new Resource[0]).stream().findFirst().orElse(null);
    }

    public static Collection<Statement> tripleAsStatements(RDFTriple triple, Resource ... contexts) {
        Object object;
        IRI predicate;
        BNode subject;
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        if (triple.getSubject() instanceof RDFResourceIRI) {
            try {
                subject = vf.createIRI(triple.getSubject().getIRI().toString());
            }
            catch (IllegalArgumentException iae) {
                LOGGER.error("Subject URI was invalid: {}", (Object)triple);
                return Collections.emptyList();
            }
        } else {
            subject = RioUtils.node((RDFNode)triple.getSubject(), (ValueFactory)vf);
        }
        try {
            predicate = vf.createIRI(triple.getPredicate().getIRI().toString());
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error("Predicate URI was invalid: {}", (Object)triple);
            return Collections.emptyList();
        }
        if (triple.getObject() instanceof RDFResourceIRI) {
            try {
                object = vf.createIRI(triple.getObject().getIRI().toString());
            }
            catch (IllegalArgumentException iae) {
                LOGGER.error("Object URI was invalid: {}", (Object)triple);
                return Collections.emptyList();
            }
        } else {
            object = triple.getObject() instanceof RDFLiteral ? RioUtils.literal((ValueFactory)vf, (RDFLiteral)triple.getObject()) : RioUtils.node(triple.getObject(), (ValueFactory)vf);
        }
        if (contexts == null || contexts.length == 0) {
            return Collections.singletonList(vf.createStatement((Resource)subject, predicate, (Value)object));
        }
        return OWLAPIStreamUtils.asList(Stream.of(contexts).map(arg_0 -> RioUtils.lambda$tripleAsStatements$0((ValueFactory)vf, (Resource)subject, predicate, (Value)object, arg_0)));
    }

    protected static Value literal(ValueFactory vf, RDFLiteral literalObject) {
        Literal object = literalObject.hasLang() ? vf.createLiteral(literalObject.getLexicalValue(), literalObject.getLang()) : (literalObject.isPlainLiteral() ? vf.createLiteral(literalObject.getLexicalValue(), XMLSchema.STRING) : vf.createLiteral(literalObject.getLexicalValue(), vf.createIRI(literalObject.getDatatype().toString())));
        return object;
    }

    protected static BNode node(RDFNode node, ValueFactory vf) {
        if (node.getIRI().getNamespace().startsWith("_:")) {
            return vf.createBNode(node.getIRI().toString().substring(2));
        }
        return vf.createBNode(node.getIRI().toString());
    }

    private static /* synthetic */ Statement lambda$tripleAsStatements$0(ValueFactory vf, Resource subject, IRI predicate, Value object, Resource x) {
        return vf.createStatement(subject, predicate, object, x);
    }
}

