/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import java.io.File;
import org.openrdf.OpenRDFException;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryBase;
import org.openrdf.repository.sail.config.RepositoryResolver;
import org.openrdf.repository.sail.config.RepositoryResolverClient;

public class ProxyRepository
extends RepositoryBase
implements RepositoryResolverClient {
    private File dataDir;
    private Repository proxiedRepository;
    private String proxiedID;
    private RepositoryResolver resolver;

    public ProxyRepository() {
    }

    public ProxyRepository(RepositoryResolver resolver, String proxiedIdentity) {
        this.setRepositoryResolver(resolver);
        this.setProxiedIdentity(proxiedIdentity);
    }

    public final void setProxiedIdentity(String value) {
        if (!value.equals(this.proxiedID)) {
            this.proxiedID = value;
            this.proxiedRepository = null;
        }
    }

    public String getProxiedIdentity() {
        return this.proxiedID;
    }

    @Override
    public final void setRepositoryResolver(RepositoryResolver resolver) {
        if (resolver != this.resolver) {
            this.resolver = resolver;
            this.proxiedRepository = null;
        }
    }

    private Repository getProxiedRepository() {
        if (null == this.proxiedRepository) {
            assert (null != this.resolver) : "Expected resolver to be set.";
            assert (null != this.proxiedID) : "Expected proxiedID to be set.";
            try {
                this.proxiedRepository = this.resolver.getRepository(this.proxiedID);
            }
            catch (OpenRDFException ore) {
                throw new IllegalStateException(ore);
            }
        }
        return this.proxiedRepository;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public boolean isWritable() throws RepositoryException {
        return this.getProxiedRepository().isWritable();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        return this.getProxiedRepository().getConnection();
    }

    public ValueFactory getValueFactory() {
        return this.getProxiedRepository().getValueFactory();
    }

    protected void initializeInternal() throws RepositoryException {
        this.getProxiedRepository().initialize();
    }

    protected void shutDownInternal() throws RepositoryException {
        this.getProxiedRepository().shutDown();
    }
}

