/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IKeyArrayIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.service.AbstractClient;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.AbstractDataServiceProcedureTask;
import com.bigdata.service.ndx.ClientIndexView;
import com.bigdata.service.ndx.IScaleOutClientIndex;
import com.bigdata.service.ndx.IndexSyncRPCCounters;
import java.util.concurrent.atomic.AtomicInteger;

class KeyArrayDataServiceProcedureTask
extends AbstractDataServiceProcedureTask {
    protected final byte[][] keys;
    protected final byte[][] vals;
    protected final AbstractKeyArrayIndexProcedureConstructor ctor;

    @Override
    protected int getElementCount() {
        return this.split.ntuples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyArrayDataServiceProcedureTask(IScaleOutClientIndex ndx, byte[][] keys, byte[][] vals, long ts, Split split, IKeyArrayIndexProcedure proc, IResultHandler resultHandler, AbstractKeyArrayIndexProcedureConstructor ctor) {
        super(ndx, ts, split, proc, resultHandler);
        if (ctor == null) {
            throw new IllegalArgumentException();
        }
        this.ctor = ctor;
        this.keys = keys;
        this.vals = vals;
        IndexSyncRPCCounters indexSyncRPCCounters = this.taskCountersByIndex;
        synchronized (indexSyncRPCCounters) {
            ++this.taskCountersByIndex.keyArrayRequestCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void retry() throws Exception {
        IndexSyncRPCCounters indexSyncRPCCounters = this.taskCountersByIndex;
        synchronized (indexSyncRPCCounters) {
            ++this.taskCountersByIndex.redirectCount;
        }
        AtomicInteger recursionDepth = this.ndx.getRecursionDepth();
        int depth = recursionDepth.incrementAndGet();
        try {
            if (depth > ((AbstractClient)this.ndx.getFederation().getClient()).getMaxStaleLocatorRetries()) {
                throw new RuntimeException("Retry count exceeded: ntries=" + depth);
            }
            ((ClientIndexView)this.ndx).submit(this.ts, this.split.fromIndex, this.split.toIndex, this.keys, this.vals, this.ctor, this.resultHandler);
        }
        finally {
            int tmp = recursionDepth.decrementAndGet();
            assert (tmp >= 0) : "depth=" + depth + ", tmp=" + tmp;
        }
    }
}

