/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial.impl;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.internal.gis.CoordinateUtility;
import com.bigdata.rdf.internal.gis.ICoordinate;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.service.geospatial.GeoSpatial;
import com.bigdata.service.geospatial.IGeoSpatialQuery;
import com.bigdata.service.geospatial.impl.GeoSpatialUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class GeoSpatialQuery
implements IGeoSpatialQuery {
    private static final Logger log = Logger.getLogger(GeoSpatialQuery.class);
    final GeoSpatial.GeoFunction searchFunction;
    final IConstant<?> subject;
    final TermNode predicate;
    final TermNode context;
    final GeoSpatialUtility.PointLatLon spatialCircleCenter;
    final Double spatialCircleRadius;
    final GeoSpatialUtility.PointLatLon spatialRectangleSouthWest;
    final GeoSpatialUtility.PointLatLon spatialRectangleNorthEast;
    final ICoordinate.UNITS spatialUnit;
    final Long timeStart;
    final Long timeEnd;
    final IVariable<?> locationVar;
    final IVariable<?> timeVar;
    final IVariable<?> locationAndTimeVar;
    final IBindingSet incomingBindings;
    final GeoSpatialUtility.PointLatLonTime boundingBoxSouthWestWithTime;
    final GeoSpatialUtility.PointLatLonTime boundingBoxNorthEastWithTime;

    public GeoSpatialQuery(GeoSpatial.GeoFunction searchFunction, IConstant<?> subject, TermNode predicate, TermNode context, GeoSpatialUtility.PointLatLon spatialCircleCenter, Double spatialCircleRadius, GeoSpatialUtility.PointLatLon spatialRectangleSouthWest, GeoSpatialUtility.PointLatLon spatialRectangleNorthEast, ICoordinate.UNITS spatialUnit, Long timeStart, Long timeEnd, IVariable<?> locationVar, IVariable<?> timeVar, IVariable<?> locationAndTimeVar, IBindingSet incomingBindings) {
        this.searchFunction = searchFunction;
        this.subject = subject;
        this.predicate = predicate;
        this.context = context;
        this.spatialCircleCenter = spatialCircleCenter;
        this.spatialCircleRadius = spatialCircleRadius;
        this.spatialRectangleSouthWest = spatialRectangleSouthWest;
        this.spatialRectangleNorthEast = spatialRectangleNorthEast;
        this.spatialUnit = spatialUnit;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.locationVar = locationVar;
        this.timeVar = timeVar;
        this.locationAndTimeVar = locationAndTimeVar;
        this.incomingBindings = incomingBindings;
        switch (searchFunction) {
            case IN_CIRCLE: {
                CoordinateDD centerPointDD = spatialCircleCenter.asCoordinateDD();
                CoordinateDD southWest = CoordinateUtility.boundingBoxSouthWest(centerPointDD, spatialCircleRadius, spatialUnit);
                CoordinateDD northEast = CoordinateUtility.boundingBoxNorthEast(centerPointDD, spatialCircleRadius, spatialUnit);
                this.boundingBoxSouthWestWithTime = new GeoSpatialUtility.PointLatLonTime(southWest, timeStart);
                this.boundingBoxNorthEastWithTime = new GeoSpatialUtility.PointLatLonTime(northEast, timeEnd);
                break;
            }
            case IN_RECTANGLE: {
                this.boundingBoxSouthWestWithTime = new GeoSpatialUtility.PointLatLonTime(spatialRectangleSouthWest, timeStart);
                this.boundingBoxNorthEastWithTime = new GeoSpatialUtility.PointLatLonTime(spatialRectangleNorthEast, timeEnd);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid searchFunction: " + (Object)((Object)searchFunction));
            }
        }
    }

    private GeoSpatialQuery(GeoSpatial.GeoFunction searchFunction, IConstant<?> subject, TermNode predicate, TermNode context, GeoSpatialUtility.PointLatLon spatialCircleCenter, Double spatialCircleRadius, GeoSpatialUtility.PointLatLon spatialRectangleSouthWest, GeoSpatialUtility.PointLatLon spatialRectangleNorthEast, ICoordinate.UNITS spatialUnit, Long timeStart, Long timeEnd, IVariable<?> locationVar, IVariable<?> timeVar, IVariable<?> locationAndTimeVar, IBindingSet incomingBindings, GeoSpatialUtility.PointLatLonTime boundingBoxSouthWestWithTime, GeoSpatialUtility.PointLatLonTime boundingBoxNorthEastWithTime) {
        this.searchFunction = searchFunction;
        this.subject = subject;
        this.predicate = predicate;
        this.context = context;
        this.spatialCircleCenter = spatialCircleCenter;
        this.spatialCircleRadius = spatialCircleRadius;
        this.spatialRectangleSouthWest = spatialRectangleSouthWest;
        this.spatialRectangleNorthEast = spatialRectangleNorthEast;
        this.spatialUnit = spatialUnit;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.locationVar = locationVar;
        this.timeVar = timeVar;
        this.locationAndTimeVar = locationAndTimeVar;
        this.incomingBindings = incomingBindings;
        this.boundingBoxSouthWestWithTime = boundingBoxSouthWestWithTime;
        this.boundingBoxNorthEastWithTime = boundingBoxNorthEastWithTime;
    }

    @Override
    public GeoSpatial.GeoFunction getSearchFunction() {
        return this.searchFunction;
    }

    @Override
    public IConstant<?> getSubject() {
        return this.subject;
    }

    @Override
    public TermNode getPredicate() {
        return this.predicate;
    }

    @Override
    public TermNode getContext() {
        return this.context;
    }

    @Override
    public GeoSpatialUtility.PointLatLon getSpatialCircleCenter() {
        return this.spatialCircleCenter;
    }

    @Override
    public Double getSpatialCircleRadius() {
        return this.spatialCircleRadius;
    }

    @Override
    public GeoSpatialUtility.PointLatLon getSpatialRectangleSouthWest() {
        return this.spatialRectangleSouthWest;
    }

    @Override
    public GeoSpatialUtility.PointLatLon getSpatialRectangleNorthEast() {
        return this.spatialRectangleNorthEast;
    }

    @Override
    public ICoordinate.UNITS getSpatialUnit() {
        return this.spatialUnit;
    }

    @Override
    public Long getTimeStart() {
        return this.timeStart;
    }

    @Override
    public Long getTimeEnd() {
        return this.timeEnd;
    }

    @Override
    public IVariable<?> getLocationVar() {
        return this.locationVar;
    }

    @Override
    public IVariable<?> getTimeVar() {
        return this.timeVar;
    }

    @Override
    public IVariable<?> getLocationAndTimeVar() {
        return this.locationAndTimeVar;
    }

    @Override
    public IBindingSet getIncomingBindings() {
        return this.incomingBindings;
    }

    @Override
    public GeoSpatialUtility.PointLatLonTime getBoundingBoxSouthWestWithTime() {
        return this.boundingBoxSouthWestWithTime;
    }

    @Override
    public GeoSpatialUtility.PointLatLonTime getBoundingBoxNorthEastWithTime() {
        return this.boundingBoxNorthEastWithTime;
    }

    @Override
    public List<IGeoSpatialQuery> normalize() {
        if (this.boundingBoxSouthWestWithTime.getLat() > this.boundingBoxNorthEastWithTime.getLat()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Search rectangle upper left latitude (" + this.boundingBoxSouthWestWithTime.getLat() + ") is larger than rectangle lower righ latitude (" + this.boundingBoxNorthEastWithTime.getLat() + ". Search request will give no results."));
            }
            return new LinkedList<IGeoSpatialQuery>();
        }
        if (this.boundingBoxSouthWestWithTime.getTimestamp() > this.boundingBoxNorthEastWithTime.getTimestamp()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Search rectangle upper left timestamp (" + this.boundingBoxSouthWestWithTime.getTimestamp() + ") is larger than rectangle lower right timestamp (" + this.boundingBoxNorthEastWithTime.getTimestamp() + ". Search request will give no results."));
            }
            return new LinkedList<IGeoSpatialQuery>();
        }
        if (this.boundingBoxSouthWestWithTime.getLon() > this.boundingBoxNorthEastWithTime.getLon()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Search rectangle upper left latitude (" + this.boundingBoxSouthWestWithTime.getLat() + ") is larger than rectangle lower righ latitude (" + this.boundingBoxNorthEastWithTime.getLat() + ". Search will be split into two search windows."));
            }
            ArrayList<IGeoSpatialQuery> normalizedQueries = new ArrayList<IGeoSpatialQuery>(2);
            GeoSpatialQuery query1 = this.cloneWithAdjustedBoundingBox(new GeoSpatialUtility.PointLatLonTime(this.boundingBoxSouthWestWithTime.getLat(), Math.nextAfter(-180.0, 0.0), this.boundingBoxSouthWestWithTime.getTimestamp()), new GeoSpatialUtility.PointLatLonTime(this.boundingBoxNorthEastWithTime.getLat(), this.boundingBoxNorthEastWithTime.getLon(), this.boundingBoxNorthEastWithTime.getTimestamp()));
            normalizedQueries.add(query1);
            GeoSpatialQuery query2 = this.cloneWithAdjustedBoundingBox(new GeoSpatialUtility.PointLatLonTime(this.boundingBoxSouthWestWithTime.getLat(), this.boundingBoxSouthWestWithTime.getLon(), this.boundingBoxSouthWestWithTime.getTimestamp()), new GeoSpatialUtility.PointLatLonTime(this.boundingBoxNorthEastWithTime.getLat(), 180.0, this.boundingBoxNorthEastWithTime.getTimestamp()));
            normalizedQueries.add(query2);
            return normalizedQueries;
        }
        return Arrays.asList(this);
    }

    @Override
    public boolean isNormalized() {
        if (this.boundingBoxSouthWestWithTime.getLat() > this.boundingBoxNorthEastWithTime.getLat()) {
            return false;
        }
        if (this.boundingBoxSouthWestWithTime.getTimestamp() > this.boundingBoxNorthEastWithTime.getTimestamp()) {
            return false;
        }
        return !(this.boundingBoxSouthWestWithTime.getLon() > this.boundingBoxNorthEastWithTime.getLon());
    }

    public GeoSpatialQuery cloneWithAdjustedBoundingBox(GeoSpatialUtility.PointLatLonTime boundingBoxSouthWestWithTime, GeoSpatialUtility.PointLatLonTime boundingBoxNorthEastWithTime) {
        return new GeoSpatialQuery(this.searchFunction, this.subject, this.predicate, this.context, this.spatialCircleCenter, this.spatialCircleRadius, this.spatialRectangleSouthWest, this.spatialRectangleNorthEast, this.spatialUnit, this.timeStart, this.timeEnd, this.locationVar, this.timeVar, this.locationAndTimeVar, this.incomingBindings, boundingBoxSouthWestWithTime, boundingBoxNorthEastWithTime);
    }
}

