/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.IndexMetadata;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.resources.AbstractResult;
import com.bigdata.service.DataService;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class MoveResult
extends AbstractResult {
    public final UUID targetDataServiceUUID;
    public final int newPartitionId;
    public final String targetIndexName;
    public final PartitionLocator oldLocator;
    public final PartitionLocator newLocator;
    protected final AtomicBoolean registeredInMDS = new AtomicBoolean(false);

    public MoveResult(String name, IndexMetadata indexMetadata, UUID targetDataServiceUUID, int newPartitionId, PartitionLocator oldLocator, PartitionLocator newLocator) {
        super(name, indexMetadata);
        if (targetDataServiceUUID == null) {
            throw new IllegalArgumentException();
        }
        if (oldLocator == null) {
            throw new IllegalArgumentException();
        }
        if (newLocator == null) {
            throw new IllegalArgumentException();
        }
        this.targetDataServiceUUID = targetDataServiceUUID;
        this.newPartitionId = newPartitionId;
        this.targetIndexName = DataService.getIndexPartitionName(indexMetadata.getName(), newPartitionId);
        this.oldLocator = oldLocator;
        this.newLocator = newLocator;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MoveResult");
        sb.append("{ name=" + this.name);
        sb.append(", newPartitionId=" + this.newPartitionId);
        sb.append(", targetDataService=" + this.targetDataServiceUUID);
        sb.append(", oldLocator=" + this.oldLocator);
        sb.append(", newLocator=" + this.newLocator);
        sb.append(" }");
        return sb.toString();
    }
}

