/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.rdf.update.ChunkedResolutionOp;
import com.bigdata.bop.rdf.update.InsertStatementsOp;
import com.bigdata.bop.rdf.update.RemoveStatementsOp;
import com.bigdata.rdf.error.SparqlDynamicErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.rio.IRDFParserOptions;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.SPARQLUpdateEvent;
import com.bigdata.rdf.sail.Sesame2BigdataIterator;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractGraphDataUpdate;
import com.bigdata.rdf.sparql.ast.AddGraph;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.CopyGraph;
import com.bigdata.rdf.sparql.ast.CreateGraph;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.DeleteInsertGraph;
import com.bigdata.rdf.sparql.ast.DropGraph;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.LoadGraph;
import com.bigdata.rdf.sparql.ast.MoveGraph;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QuadData;
import com.bigdata.rdf.sparql.ast.QuadsDataOrNamedSolutionSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.Update;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.UpdateType;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUpdateContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.ASTConstructIterator;
import com.bigdata.rdf.sparql.ast.eval.ASTDeferredIVResolution;
import com.bigdata.rdf.sparql.ast.eval.ASTEvalHelper;
import com.bigdata.rdf.sparql.ast.eval.MutableTupleQueryResult;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.BD;
import com.bigdata.rdf.store.BigdataOpenRDFBindingSetsResolverator;
import com.bigdata.striterator.Chunkerator;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.sail.SailException;

public class AST2BOpUpdate
extends AST2BOpUtility {
    private static final Logger log = Logger.getLogger(AST2BOpUpdate.class);
    private static final boolean runOnQueryEngine = false;
    private static final Var<?> s = Var.var("s");
    private static final Var<?> p = Var.var("p");
    private static final Var<?> o = Var.var("o");
    private static final Var<?> c = Var.var("c");
    public static boolean AUTO_COMMIT = Boolean.parseBoolean(System.getProperty(AST2BOpBase.Annotations.AUTO_COMMIT, "true"));
    private static final IBindingSet[] EMPTY_BINDING_SETS = new IBindingSet[0];
    private static final Resource[] NO_CONTEXTS = new Resource[0];

    protected static void optimizeUpdateRoot(AST2BOpUpdateContext context) {
    }

    protected static PipelineOp convertUpdate(AST2BOpUpdateContext context) throws Exception {
        if (context.db.isReadOnly()) {
            throw new UnsupportedOperationException("Not a mutable view.");
        }
        if (context.conn.isReadOnly()) {
            throw new UnsupportedOperationException("Not a mutable view.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("beforeUpdate:\n" + context.getAbstractTripleStore().dumpStore()));
        }
        ASTContainer astContainer = context.astContainer;
        UpdateRoot updateRoot = astContainer.getOriginalUpdateAST();
        PipelineOp left = null;
        int updateIndex = 0;
        for (Update op : updateRoot) {
            long connectionFlushNanos = 0L;
            long batchResolveNanos = 0L;
            if (updateIndex > 0) {
                long t1 = System.nanoTime();
                context.conn.flush();
                long t2 = System.nanoTime();
                connectionFlushNanos = t2 - t1;
                ASTDeferredIVResolution.resolveUpdate(context.db, op, (BindingSet)context.getQueryBindingSet(), context.getDataset());
                batchResolveNanos = System.nanoTime() - t2;
            }
            long begin = System.nanoTime();
            SPARQLUpdateEvent.DeleteInsertWhereStats deleteInsertWhereStats = new SPARQLUpdateEvent.DeleteInsertWhereStats();
            Throwable cause = null;
            try {
                left = AST2BOpUpdate.convertUpdateSwitch(left, op, context, deleteInsertWhereStats);
            }
            catch (Throwable t) {
                cause = t;
                log.error((Object)("SPARQL UPDATE failure: op=" + op + ", ex=" + t), t);
                long elapsed = System.nanoTime() - begin;
                context.conn.getSailConnection().fireEvent(new SPARQLUpdateEvent(op, elapsed, connectionFlushNanos, batchResolveNanos, cause, deleteInsertWhereStats));
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            long elapsed = System.nanoTime() - begin;
            context.conn.getSailConnection().fireEvent(new SPARQLUpdateEvent(op, elapsed, connectionFlushNanos, batchResolveNanos, cause, deleteInsertWhereStats));
            ++updateIndex;
        }
        left = AST2BOpUpdate.convertCommit(left, context);
        if (log.isTraceEnabled()) {
            log.trace((Object)("afterCommit:\n" + context.getAbstractTripleStore().dumpStore()));
        }
        return left;
    }

    private static PipelineOp convertCommit(PipelineOp left, AST2BOpUpdateContext context) throws Exception {
        if (AUTO_COMMIT) {
            long commitTime = context.conn.commit2();
            context.setCommitTime(commitTime);
            if (log.isDebugEnabled()) {
                log.debug((Object)("COMMIT: commitTime=" + commitTime));
            }
        }
        return left;
    }

    private static PipelineOp convertUpdateSwitch(PipelineOp left, Update op, AST2BOpUpdateContext context, SPARQLUpdateEvent.DeleteInsertWhereStats deleteInsertWhereStats) throws Exception {
        UpdateType updateType = op.getUpdateType();
        switch (updateType) {
            case Create: {
                left = AST2BOpUpdate.convertCreateGraph(left, (CreateGraph)op, context);
                break;
            }
            case Add: {
                left = AST2BOpUpdate.convertAddGraph(left, (AddGraph)op, context);
                break;
            }
            case Copy: {
                left = AST2BOpUpdate.convertCopyGraph(left, (CopyGraph)op, context);
                break;
            }
            case Move: {
                left = AST2BOpUpdate.convertMoveGraph(left, (MoveGraph)op, context);
                break;
            }
            case Clear: 
            case Drop: {
                left = AST2BOpUpdate.convertClearOrDropGraph(left, (DropGraph)op, context);
                break;
            }
            case InsertData: 
            case DeleteData: {
                left = AST2BOpUpdate.convertInsertOrDeleteData(left, (AbstractGraphDataUpdate)op, context);
                break;
            }
            case Load: {
                left = AST2BOpUpdate.convertLoadGraph(left, (LoadGraph)op, context);
                break;
            }
            case DeleteInsert: {
                left = AST2BOpUpdate.convertDeleteInsert(left, (DeleteInsertGraph)op, context, deleteInsertWhereStats);
                break;
            }
            case DropEntailments: {
                left = AST2BOpUpdate.convertDropEntailments(left, context);
                break;
            }
            case CreateEntailments: {
                left = AST2BOpUpdate.convertCreateEntailments(left, context);
                break;
            }
            case EnableEntailments: {
                left = AST2BOpUpdate.convertEnableEntailments(left, context);
                break;
            }
            case DisableEntailments: {
                left = AST2BOpUpdate.convertDisableEntailments(left, context);
                break;
            }
            default: {
                throw new UnsupportedOperationException("updateType=" + (Object)((Object)updateType));
            }
        }
        return left;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PipelineOp convertDeleteInsert(PipelineOp left, DeleteInsertGraph op, AST2BOpUpdateContext context, SPARQLUpdateEvent.DeleteInsertWhereStats deleteInsertWhereStats) throws QueryEvaluationException, RepositoryException, SailException {
        QuadsDataOrNamedSolutionSet clause;
        boolean isDeleteInsert;
        JoinGroupNode whereClause = new JoinGroupNode((IGroupMemberNode)op.getWhereClause());
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        queryRoot.setWhereClause(whereClause);
        DatasetNode dataset = op.getDataset();
        if (dataset != null) {
            queryRoot.setDataset(dataset);
        }
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        Set<IVariable<?>> projectedVars = sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true);
        for (IBindingSet bs : context.getBindings()) {
            Iterator it = bs.vars();
            while (it.hasNext()) {
                projectedVars.add((IVariable<?>)it.next());
            }
        }
        ProjectionNode projection = new ProjectionNode();
        for (IVariable<?> var : projectedVars) {
            projection.addProjectionVar(new VarNode(var.getName()));
        }
        queryRoot.setProjection(projection);
        ASTContainer astContainer = new ASTContainer(queryRoot);
        astContainer.setProperty("resolved", context.astContainer.getProperty("resolved"));
        QuadsDataOrNamedSolutionSet insertClause = op.getInsertClause();
        if (insertClause == null && op.getDeleteClause() == null) {
            QuadData deleteTemplate = new QuadData();
            Iterator<StatementPatternNode> itr = BOpUtility.visitAll(whereClause, StatementPatternNode.class);
            while (itr.hasNext()) {
                StatementPatternNode t = (StatementPatternNode)itr.next().clone();
                deleteTemplate.addChild(t);
            }
            QuadsDataOrNamedSolutionSet deleteClause = new QuadsDataOrNamedSolutionSet(deleteTemplate);
            op.setDeleteClause(deleteClause);
        }
        QuadsDataOrNamedSolutionSet deleteClause = op.getDeleteClause();
        boolean isInsertOnly = insertClause != null && deleteClause == null;
        boolean bl = isDeleteInsert = insertClause != null && deleteClause != null;
        if (isDeleteInsert) {
            LexiconRelation lexicon = context.getAbstractTripleStore().getLexiconRelation();
            int chunkSize = 100;
            long beginWhereClauseNanos = System.nanoTime();
            MutableTupleQueryResult result = new MutableTupleQueryResult(ASTEvalHelper.evaluateTupleQuery(context.conn.getTripleStore(), astContainer, context.getQueryBindingSet(), null));
            deleteInsertWhereStats.whereNanos.set(System.nanoTime() - beginWhereClauseNanos);
            boolean nativeDistinct = astContainer.getOptimizedAST().getProperty("nativeDistinct", false);
            try {
                BigdataStatement stmt;
                ASTConstructIterator itr;
                ConstructNode template;
                String solutionSet;
                boolean isSolutionSet;
                long beginDeleteNanos;
                block36: {
                    beginDeleteNanos = System.nanoTime();
                    result.beforeFirst();
                    isSolutionSet = deleteClause.isSolutions();
                    if (isSolutionSet) {
                        solutionSet = deleteClause.getName();
                        String tempSolutionSet = "-" + solutionSet + "-" + UUID.randomUUID();
                        context.solutionSetManager.putSolutions(tempSolutionSet, AST2BOpUpdate.asBigdataIterator(lexicon, 100, (CloseableIteration<BindingSet, QueryEvaluationException>)result));
                        try {
                            JoinGroupNode newWhereClause = new JoinGroupNode();
                            queryRoot.setWhereClause(newWhereClause);
                            newWhereClause.addArg(new NamedSubqueryInclude(solutionSet));
                            JoinGroupNode minusOp = new JoinGroupNode((IGroupMemberNode)new NamedSubqueryInclude(tempSolutionSet));
                            newWhereClause.addArg(minusOp);
                            minusOp.setMinus(true);
                            queryRoot.setProjection(deleteClause.getProjection());
                            try (ICloseableIterator<IBindingSet[]> titr = ASTEvalHelper.evaluateTupleQuery2(context.conn.getTripleStore(), astContainer, context.getQueryBindingSet(), false);){
                                context.solutionSetManager.putSolutions(solutionSet, titr);
                                break block36;
                            }
                        }
                        finally {
                            context.solutionSetManager.clearSolutions(tempSolutionSet);
                        }
                    }
                    template = op.getDeleteClause().getQuadData().flatten(new ConstructNode(context));
                    template.setDistinctQuads(true);
                    if (nativeDistinct) {
                        template.setNativeDistinct(true);
                    }
                    itr = new ASTConstructIterator(context, context.conn.getTripleStore(), template, op.getWhereClause(), null, (CloseableIteration<BindingSet, QueryEvaluationException>)result);
                    while (itr.hasNext()) {
                        stmt = itr.next();
                        AST2BOpUpdate.addOrRemoveStatement(context.conn.getSailConnection(), stmt, false);
                    }
                }
                deleteInsertWhereStats.deleteNanos.set(System.nanoTime() - beginDeleteNanos);
                long beginInsertNanos = System.nanoTime();
                result.beforeFirst();
                isSolutionSet = insertClause.isSolutions();
                if (isSolutionSet) {
                    solutionSet = insertClause.getName();
                    queryRoot.setProjection(insertClause.getProjection());
                    try (ICloseableIterator<IBindingSet[]> titr = AST2BOpUpdate.asBigdataIterator(lexicon, 100, (CloseableIteration<BindingSet, QueryEvaluationException>)result);){
                        context.solutionSetManager.putSolutions(solutionSet, titr);
                    }
                } else {
                    template = op.getInsertClause().getQuadData().flatten(new ConstructNode(context));
                    template.setDistinctQuads(true);
                    if (nativeDistinct) {
                        template.setNativeDistinct(true);
                    }
                    itr = new ASTConstructIterator(context, context.conn.getTripleStore(), template, op.getWhereClause(), null, (CloseableIteration<BindingSet, QueryEvaluationException>)result);
                    while (itr.hasNext()) {
                        stmt = itr.next();
                        AST2BOpUpdate.addOrRemoveStatement(context.conn.getSailConnection(), stmt, true);
                    }
                }
                deleteInsertWhereStats.insertNanos.set(System.nanoTime() - beginInsertNanos);
            }
            finally {
                result.close();
            }
        }
        boolean isInsert = insertClause != null;
        QuadsDataOrNamedSolutionSet quadsDataOrNamedSolutionSet = clause = isInsert ? insertClause : deleteClause;
        assert (clause != null);
        boolean isSolutionSet = clause.isSolutions();
        if (isSolutionSet) {
            String solutionSet = clause.getName();
            queryRoot.setProjection(clause.getProjection());
            if (!isInsert) {
                AST2BOpUpdate.convertQueryForDeleteSolutions(queryRoot, solutionSet);
            }
            try (ICloseableIterator<IBindingSet[]> result = ASTEvalHelper.evaluateTupleQuery2(context.conn.getTripleStore(), astContainer, context.getQueryBindingSet(), false);){
                context.solutionSetManager.putSolutions(solutionSet, result);
            }
        }
        QuadData quadData = (insertClause == null ? deleteClause : insertClause).getQuadData();
        ConstructNode template = quadData.flatten(new ConstructNode(context));
        template.setDistinctQuads(true);
        queryRoot.setConstruct(template);
        try (GraphQueryResult result = ASTEvalHelper.evaluateGraphQuery(context.conn.getTripleStore(), astContainer, context.getQueryBindingSet(), null);){
            while (result.hasNext()) {
                BigdataStatement stmt = (BigdataStatement)result.next();
                AST2BOpUpdate.addOrRemoveStatement(context.conn.getSailConnection(), stmt, isInsertOnly);
            }
        }
        return null;
    }

    private static ICloseableIterator<IBindingSet[]> asBigdataIterator(final LexiconRelation r, int chunkSize, CloseableIteration<BindingSet, QueryEvaluationException> result) {
        Striterator sitr = new Striterator(new Chunkerator(new Sesame2BigdataIterator<BindingSet, QueryEvaluationException>(result), chunkSize));
        sitr.addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object obj) {
                BindingSet[] in = (BindingSet[])obj;
                IBindingSet[] out = BigdataOpenRDFBindingSetsResolverator.resolveChunk(r, in);
                return out;
            }
        });
        return sitr;
    }

    private static void convertQueryForDeleteSolutions(QueryRoot queryRoot, String solutionSet) {
        JoinGroupNode oldWhereClause = (JoinGroupNode)queryRoot.getWhereClause();
        JoinGroupNode newWhereClause = new JoinGroupNode();
        queryRoot.setWhereClause(newWhereClause);
        NamedSubqueryInclude includeOp = new NamedSubqueryInclude(solutionSet);
        newWhereClause.addArg(includeOp);
        JoinGroupNode minusOp = new JoinGroupNode();
        minusOp.setMinus(true);
        newWhereClause.addArg(minusOp);
        minusOp.addArg(oldWhereClause.clone());
    }

    private static PipelineOp convertAddGraph(PipelineOp left, AddGraph op, AST2BOpUpdateContext context) throws RepositoryException {
        BigdataURI sourceGraph = (BigdataURI)(op.getSourceGraph() == null ? null : op.getSourceGraph().getValue());
        BigdataURI targetGraph = (BigdataURI)(op.getTargetGraph() == null ? null : op.getTargetGraph().getValue());
        AST2BOpUpdate.copyStatements(context, op.isSilent(), sourceGraph, targetGraph);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStatements(AST2BOpUpdateContext context, boolean silent, BigdataURI sourceGraph, BigdataURI targetGraph) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sourceGraph=" + sourceGraph + ", targetGraph=" + targetGraph));
        }
        if (!silent) {
            // empty if block
        }
        try (RepositoryResult result = context.conn.getStatements(null, null, null, context.isIncludeInferred(), new Resource[]{sourceGraph});){
            context.conn.add((Iteration)result, new Resource[]{targetGraph});
        }
    }

    private static PipelineOp convertMoveGraph(PipelineOp left, MoveGraph op, AST2BOpUpdateContext context) throws RepositoryException, SailException {
        BigdataURI sourceGraph = (BigdataURI)(op.getSourceGraph() == null ? context.f.asValue(BD.NULL_GRAPH) : op.getSourceGraph().getValue());
        BigdataURI targetGraph = (BigdataURI)(op.getTargetGraph() == null ? context.f.asValue(BD.NULL_GRAPH) : op.getTargetGraph().getValue());
        if (log.isDebugEnabled()) {
            log.debug((Object)("sourceGraph=" + sourceGraph + ", targetGraph=" + targetGraph));
        }
        if (!sourceGraph.equals(targetGraph)) {
            AST2BOpUpdate.clearOneGraph(targetGraph, context);
            AST2BOpUpdate.copyStatements(context, op.isSilent(), sourceGraph, targetGraph);
            AST2BOpUpdate.clearOneGraph(sourceGraph, context);
        }
        return null;
    }

    private static PipelineOp convertCopyGraph(PipelineOp left, CopyGraph op, AST2BOpUpdateContext context) throws RepositoryException, SailException {
        BigdataURI sourceGraph = (BigdataURI)(op.getSourceGraph() == null ? context.f.asValue(BD.NULL_GRAPH) : op.getSourceGraph().getValue());
        BigdataURI targetGraph = (BigdataURI)(op.getTargetGraph() == null ? context.f.asValue(BD.NULL_GRAPH) : op.getTargetGraph().getValue());
        if (log.isDebugEnabled()) {
            log.debug((Object)("sourceGraph=" + sourceGraph + ", targetGraph=" + targetGraph));
        }
        if (!sourceGraph.equals(targetGraph)) {
            AST2BOpUpdate.clearOneGraph(targetGraph, context);
            AST2BOpUpdate.copyStatements(context, op.isSilent(), sourceGraph, targetGraph);
        }
        return null;
    }

    private static PipelineOp convertLoadGraph(PipelineOp left, LoadGraph op, AST2BOpUpdateContext context) throws Exception {
        AtomicLong nmodified = new AtomicLong();
        String urlStr = op.getSourceGraph().getValue().stringValue();
        try {
            URL sourceURL = new URL(urlStr);
            BigdataURI defaultContext = (BigdataURI)(op.getTargetGraph() == null ? null : op.getTargetGraph().getValue());
            if (log.isDebugEnabled()) {
                log.debug((Object)("sourceURI=" + urlStr + ", defaultContext=" + defaultContext));
            }
            Properties defaults = context.getAbstractTripleStore().getProperties();
            boolean verifyData = Boolean.parseBoolean(op.getProperty("verifyData", p.getProperty(RDFParserOptions.Options.VERIFY_DATA, "false")));
            boolean preserveBlankNodeIDs = Boolean.parseBoolean(op.getProperty("preserveBlankNodeIDs", p.getProperty(RDFParserOptions.Options.PRESERVE_BNODE_IDS, "false")));
            boolean stopAtFirstError = Boolean.parseBoolean(op.getProperty("stopAtFirstError", p.getProperty(RDFParserOptions.Options.STOP_AT_FIRST_ERROR, "false")));
            RDFParser.DatatypeHandling dataTypeHandling = RDFParser.DatatypeHandling.valueOf((String)op.getProperty("dataTypeHandling", p.getProperty(RDFParserOptions.Options.DATATYPE_HANDLING, RDFParserOptions.Options.DEFAULT_DATATYPE_HANDLING)));
            RDFParserOptions parserOptions = new RDFParserOptions(verifyData, preserveBlankNodeIDs, stopAtFirstError, dataTypeHandling);
            AST2BOpUpdate.doLoad(context.conn.getSailConnection(), sourceURL, defaultContext, parserOptions, nmodified, op);
        }
        catch (Throwable t) {
            String msg = "Could not load: url=" + urlStr + ", cause=" + t;
            if (op.isSilent()) {
                log.warn((Object)msg);
            }
            throw new RuntimeException(msg, t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLoad(BigdataSail.BigdataSailConnection conn, URL sourceURL, URI defaultContext, IRDFParserOptions parserOptions, AtomicLong nmodified, LoadGraph op) throws IOException, RDFParseException, RDFHandlerException {
        URI defactoContext = defaultContext == null ? new URIImpl(sourceURL.toExternalForm()) : defaultContext;
        URLConnection hconn = null;
        try {
            InputStream is;
            RDFParser rdfParser;
            String baseURL;
            block16: {
                hconn = sourceURL.openConnection();
                if (hconn instanceof HttpURLConnection) {
                    ((HttpURLConnection)hconn).setRequestMethod("GET");
                }
                hconn.setDoInput(true);
                hconn.setDoOutput(false);
                hconn.setReadTimeout(0);
                String contentType = hconn.getContentType();
                baseURL = sourceURL.toExternalForm();
                String n = sourceURL.getFile();
                RDFFormat format = RDFFormat.forMIMEType((String)new MiniMime(contentType).getMimeType());
                if (format == null) {
                    RDFFormat fmt = RDFFormat.forFileName((String)n);
                    if (fmt == null && n.endsWith(".zip")) {
                        fmt = RDFFormat.forFileName((String)n.substring(0, n.length() - 4));
                    }
                    if (fmt == null && n.endsWith(".gz")) {
                        fmt = RDFFormat.forFileName((String)n.substring(0, n.length() - 3));
                    }
                    if (fmt == null) {
                        fmt = RDFFormat.RDFXML;
                    }
                    format = fmt;
                }
                if (format == null) {
                    throw new SparqlDynamicErrorException.UnknownContentTypeException(contentType);
                }
                RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
                if (rdfParserFactory == null) {
                    throw new SparqlDynamicErrorException.UnknownContentTypeException(contentType);
                }
                rdfParser = rdfParserFactory.getParser();
                rdfParser.setValueFactory((ValueFactory)conn.getTripleStore().getValueFactory());
                rdfParser.setVerifyData(parserOptions.getVerifyData());
                rdfParser.setPreserveBNodeIDs(parserOptions.getPreserveBNodeIDs());
                rdfParser.setStopAtFirstError(parserOptions.getStopAtFirstError());
                rdfParser.setDatatypeHandling(parserOptions.getDatatypeHandling());
                rdfParser.setRDFHandler((RDFHandler)new AddStatementHandler(conn, nmodified, (Resource)defactoContext, op));
                is = hconn.getInputStream();
                try {
                    if (n.endsWith(".gz")) {
                        is = new GZIPInputStream(is);
                    }
                }
                catch (Throwable t) {
                    if (is == null) break block16;
                    try {
                        is.close();
                    }
                    catch (Throwable t2) {
                        log.warn((Object)t2, t2);
                    }
                    throw new RuntimeException(t);
                }
            }
            rdfParser.parse(is, baseURL);
        }
        finally {
            if (hconn instanceof HttpURLConnection) {
                ((HttpURLConnection)hconn).disconnect();
            }
        }
    }

    private static PipelineOp convertClearOrDropGraph(PipelineOp left, DropGraph op, AST2BOpUpdateContext context) throws RepositoryException, SailException {
        ConstantNode targetGraphNode = op.getTargetGraph();
        BigdataURI targetGraph = targetGraphNode == null ? null : (BigdataURI)targetGraphNode.getValue();
        AST2BOpUpdate.clearGraph(op.isSilent(), op.getTargetSolutionSet(), targetGraph, op.getScope(), op.isAllGraphs(), op.isAllSolutionSets(), context);
        return left;
    }

    private static final void clearOneGraph(URI targetGraph, AST2BOpUpdateContext context) throws RepositoryException, SailException {
        AST2BOpUpdate.clearGraph(true, null, targetGraph, null, false, false, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearGraph(boolean silent, String solutionSet, URI targetGraph, StatementPattern.Scope scope, boolean allGraphs, boolean allSolutionSets, AST2BOpUpdateContext context) throws RepositoryException, SailException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("targetGraph=" + targetGraph + ", scope=" + scope));
        }
        BigdataSail.BigdataSailConnection sailConn = context.conn.getSailConnection();
        if (solutionSet != null && !context.solutionSetManager.clearSolutions(solutionSet) && !silent) {
            throw new SparqlDynamicErrorException.SolutionSetDoesNotExistException(solutionSet);
        }
        if (targetGraph != null) {
            sailConn.removeStatements((Resource)null, (URI)null, (Value)null, (Resource)targetGraph);
        }
        if (scope != null) {
            if (scope == StatementPattern.Scope.DEFAULT_CONTEXTS) {
                sailConn.removeStatements((Resource)null, (URI)null, (Value)null, (Resource)BD.NULL_GRAPH);
            } else {
                try (RepositoryResult result = context.conn.getContextIDs();){
                    while (result.hasNext()) {
                        Resource c = (Resource)result.next();
                        sailConn.removeStatements((Resource)null, (URI)null, (Value)null, c);
                    }
                }
            }
        }
        if (allGraphs) {
            sailConn.removeStatements(null, null, null, new Resource[0]);
        }
        if (allSolutionSets && context.solutionSetManager != null) {
            context.solutionSetManager.clearAllSolutions();
        }
    }

    private static PipelineOp convertDropEntailments(PipelineOp left, AST2BOpUpdateContext context) throws SailException {
        long stmtCount = 0L;
        if (log.isDebugEnabled()) {
            stmtCount = context.conn.getSailConnection().getTripleStore().getStatementCount(true);
            log.info((Object)"begin drop entailments");
        }
        context.conn.getSailConnection().removeAllEntailments();
        if (log.isDebugEnabled()) {
            long removedCount = stmtCount - context.conn.getSailConnection().getTripleStore().getStatementCount(true);
            log.debug((Object)("Removed statements = " + removedCount));
        }
        return left;
    }

    private static PipelineOp convertDisableEntailments(PipelineOp left, AST2BOpUpdateContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Going to disable truth maintenance");
        }
        if (context.conn.getSailConnection().isTruthMaintenanceConfigured()) {
            context.conn.getSailConnection().setTruthMaintenance(false);
        } else {
            log.debug((Object)"Truth maintenance is not configured");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("truthMaintenance = " + context.conn.getSailConnection().getTruthMaintenance()));
        }
        return left;
    }

    private static PipelineOp convertEnableEntailments(PipelineOp left, AST2BOpUpdateContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Going to enable truth maintenance");
        }
        if (context.conn.getSailConnection().isTruthMaintenanceConfigured()) {
            context.conn.getSailConnection().setTruthMaintenance(true);
        } else {
            log.debug((Object)"Truth maintenance is not configured");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("truthMaintenance = " + context.conn.getSailConnection().getTruthMaintenance()));
        }
        return left;
    }

    private static PipelineOp convertCreateEntailments(PipelineOp left, AST2BOpUpdateContext context) throws SailException {
        long stmtCount = 0L;
        if (log.isDebugEnabled()) {
            stmtCount = context.conn.getSailConnection().getTripleStore().getStatementCount(true);
            log.info((Object)"begin compute closure");
        }
        context.conn.getSailConnection().computeClosure();
        if (log.isDebugEnabled()) {
            long inferredCount = context.conn.getSailConnection().getTripleStore().getStatementCount(true) - stmtCount;
            log.debug((Object)("Inferred statements = " + inferredCount));
        }
        return left;
    }

    private static PipelineOp convertCreateGraph(PipelineOp left, CreateGraph op, AST2BOpUpdateContext context) {
        if (op.isTargetSolutionSet()) {
            String solutionSet = op.getTargetSolutionSet();
            boolean exists = context.solutionSetManager.existsSolutions(solutionSet);
            if (!op.isSilent() && exists) {
                throw new SparqlDynamicErrorException.SolutionSetExistsException(solutionSet);
            }
            if (!exists) {
                context.solutionSetManager.createSolutions(solutionSet, op.getParams());
            }
        } else {
            BigdataURI c = (BigdataURI)op.getTargetGraph().getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("targetGraph=" + c));
            }
            if (!op.isSilent()) {
                AST2BOpUpdate.assertGraphExists(context, c);
            }
        }
        return left;
    }

    private static PipelineOp convertInsertOrDeleteData(PipelineOp left, AbstractGraphDataUpdate op, AST2BOpUpdateContext context) throws Exception {
        boolean insert;
        switch (op.getUpdateType()) {
            case InsertData: {
                insert = true;
                break;
            }
            case DeleteData: {
                insert = false;
                break;
            }
            default: {
                throw new UnsupportedOperationException(op.getUpdateType().name());
            }
        }
        BigdataStatement[] stmts = op.getData();
        if (log.isDebugEnabled()) {
            log.debug((Object)((insert ? "INSERT" : "DELETE") + " DATA: #stmts=" + stmts.length));
        }
        BigdataSail.BigdataSailConnection conn = context.conn.getSailConnection();
        for (BigdataStatement s : stmts) {
            AST2BOpUpdate.addOrRemoveStatementData(conn, s, insert);
        }
        return null;
    }

    private static void addOrRemoveStatement(BigdataSail.BigdataSailConnection conn, BigdataStatement spo, boolean insert) throws SailException {
        Object[] objectArray;
        BigdataResource c;
        BigdataResource s = spo.getSubject();
        BigdataURI p = spo.getPredicate();
        BigdataValue o = spo.getObject();
        BigdataResource bigdataResource = c = spo.getContext() == null ? null : spo.getContext();
        if (c == null) {
            objectArray = NO_CONTEXTS;
        } else {
            Resource[] resourceArray = new Resource[1];
            objectArray = resourceArray;
            resourceArray[0] = c;
        }
        Object[] contexts = objectArray;
        if (log.isTraceEnabled()) {
            log.trace((Object)((insert ? "INSERT" : "DELETE") + ": <" + s + "," + p + "," + o + "," + Arrays.toString(contexts)));
        }
        if (insert) {
            conn.addStatement((Resource)s, (URI)p, (Value)o, (Resource[])contexts);
        } else {
            conn.removeStatements((Resource)s, (URI)p, (Value)o, (Resource[])contexts);
        }
    }

    private static void addOrRemoveStatementData(BigdataSail.BigdataSailConnection conn, BigdataStatement stmt, boolean insert) throws SailException {
        Object[] objectArray;
        BigdataResource c;
        BigdataResource s = stmt.getSubject();
        BigdataURI p = stmt.getPredicate();
        BigdataValue o = stmt.getObject();
        BigdataResource bigdataResource = c = stmt.getContext() == null ? null : stmt.getContext();
        if (c == null) {
            objectArray = NO_CONTEXTS;
        } else {
            Resource[] resourceArray = new Resource[1];
            objectArray = resourceArray;
            resourceArray[0] = c;
        }
        Object[] contexts = objectArray;
        if (log.isTraceEnabled()) {
            log.trace((Object)((insert ? "INSERT" : "DELETE") + ": <" + s + "," + p + "," + o + "," + Arrays.toString(contexts)));
        }
        if (insert) {
            conn.addStatement((Resource)s, (URI)p, (Value)o, (Resource[])contexts);
        } else {
            conn.removeStatements((Resource)s, (URI)p, (Value)o, (Resource[])contexts);
        }
    }

    private static PipelineOp addInsertOrDeleteDataPipeline(PipelineOp left, boolean insert, AST2BOpUpdateContext context) {
        left = new ChunkedResolutionOp(AST2BOpUpdate.leftOrEmpty(left), NV.asMap(new NV(BOp.Annotations.BOP_ID, context.nextId()), new NV(ChunkedResolutionOp.Annotations.TIMESTAMP, context.getTimestamp()), new NV(ChunkedResolutionOp.Annotations.RELATION_NAME, new String[]{context.getLexiconNamespace()})));
        left = insert ? new InsertStatementsOp(AST2BOpUpdate.leftOrEmpty(left), NV.asMap(new NV(BOp.Annotations.BOP_ID, context.nextId()), new NV(ChunkedResolutionOp.Annotations.TIMESTAMP, context.getTimestamp()), new NV(ChunkedResolutionOp.Annotations.RELATION_NAME, new String[]{context.getNamespace()}))) : new RemoveStatementsOp(AST2BOpUpdate.leftOrEmpty(left), NV.asMap(new NV(BOp.Annotations.BOP_ID, context.nextId()), new NV(ChunkedResolutionOp.Annotations.TIMESTAMP, context.getTimestamp()), new NV(ChunkedResolutionOp.Annotations.RELATION_NAME, new String[]{context.getNamespace()})));
        return left;
    }

    private static IBindingSet[] getData(ISPO[] data, IV<?, ?> targetGraph, boolean quads) {
        IBindingSet[] bsets = new IBindingSet[data.length];
        for (int i = 0; i < data.length; ++i) {
            ISPO spo = data[i];
            bsets[i] = new ListBindingSet();
            ListBindingSet bset = bsets[i];
            bset.set(s, new Constant<IV>(spo.s()));
            bset.set(p, new Constant<IV>(spo.p()));
            bset.set(o, new Constant<IV>(spo.o()));
            Constant<IV> g = null;
            if (spo.c() != null) {
                g = new Constant<IV>(spo.c());
            }
            if (quads && g == null) {
                g = new Constant(targetGraph);
            }
            if (g == null) continue;
            bset.set(c, g);
        }
        return bsets;
    }

    private static void executeUpdate(PipelineOp left, IBindingSet[] bindingSets, AST2BOpUpdateContext context) throws Exception {
        throw new UnsupportedOperationException();
    }

    private static void assertGraphNotEmpty(AST2BOpUpdateContext context, BigdataURI sourceGraph) {
        if (sourceGraph == null || sourceGraph.equals(BD.NULL_GRAPH)) {
            return;
        }
        if (sourceGraph.getIV() == null) {
            throw new SparqlDynamicErrorException.GraphEmptyException(sourceGraph);
        }
        if (context.conn.getTripleStore().getAccessPath(null, null, null, sourceGraph).isEmpty()) {
            throw new SparqlDynamicErrorException.GraphEmptyException(sourceGraph);
        }
    }

    private static void assertGraphExists(AST2BOpUpdateContext context, BigdataURI c) {
        if (c.getIV() != null && context.conn.getTripleStore().getAccessPath(null, null, null, c.getIV()).rangeCount(false) != 0L) {
            throw new SparqlDynamicErrorException.GraphExistsException(c);
        }
    }

    private static class AddStatementHandler
    extends RDFHandlerBase {
        private final LoadGraph op;
        private final long beginNanos;
        private final BigdataSail.BigdataSailConnection conn;
        private final AtomicLong nmodified;
        private final Resource[] defaultContexts;

        public AddStatementHandler(BigdataSail.BigdataSailConnection conn, AtomicLong nmodified, Resource defaultContext, LoadGraph op) {
            this.conn = conn;
            this.nmodified = nmodified;
            boolean quads = conn.getTripleStore().isQuads();
            this.defaultContexts = quads && defaultContext != null ? new Resource[]{defaultContext} : new Resource[0];
            this.op = op;
            this.beginNanos = System.nanoTime();
        }

        public void handleStatement(Statement stmt) throws RDFHandlerException {
            try {
                Resource[] resourceArray;
                Resource resource = stmt.getSubject();
                URI uRI = stmt.getPredicate();
                Value value = stmt.getObject();
                if (stmt.getContext() == null) {
                    resourceArray = this.defaultContexts;
                } else {
                    Resource[] resourceArray2 = new Resource[1];
                    resourceArray = resourceArray2;
                    resourceArray2[0] = stmt.getContext();
                }
                this.conn.addStatement(resource, uRI, value, resourceArray);
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
            long nparsed = this.nmodified.incrementAndGet();
            if (nparsed % 10000L == 0L) {
                long elapsed = System.nanoTime() - this.beginNanos;
                this.conn.fireEvent(new SPARQLUpdateEvent.LoadProgress(this.op, elapsed, nparsed, false));
            }
        }

        public void endRDF() throws RDFHandlerException {
            long nparsed = this.nmodified.get();
            long elapsed = System.nanoTime() - this.beginNanos;
            this.conn.fireEvent(new SPARQLUpdateEvent.LoadProgress(this.op, elapsed, nparsed, true));
        }
    }
}

