/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.cache;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.cache.IDescribeCache;
import info.aduna.iteration.CloseableIteration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Graph;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.query.QueryEvaluationException;

public class DescribeCacheUpdater
implements CloseableIteration<BigdataStatement, QueryEvaluationException> {
    private static final transient Logger log = Logger.getLogger(DescribeCacheUpdater.class);
    private final IDescribeCache cache;
    private final Set<BigdataValue> describedResources;
    private final CloseableIteration<BigdataStatement, QueryEvaluationException> src;
    private final HashMap<BigdataValue, Graph> graphs = new HashMap();
    private boolean open = true;

    public DescribeCacheUpdater(IDescribeCache cache, Set<BigdataValue> describedResources, CloseableIteration<BigdataStatement, QueryEvaluationException> src) {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        if (describedResources == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.cache = cache;
        this.describedResources = describedResources;
        this.src = src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() throws QueryEvaluationException {
        if (this.src.hasNext()) {
            return true;
        }
        if (this.open) {
            try {
                this.updateCache();
            }
            finally {
                this.close();
            }
        }
        return false;
    }

    public BigdataStatement next() throws QueryEvaluationException {
        BigdataValue o;
        BigdataStatement stmt = (BigdataStatement)this.src.next();
        BigdataResource s = stmt.getSubject();
        if (this.describedResources.contains(s)) {
            this.record(s, stmt);
        }
        if (this.describedResources.contains(o = stmt.getObject())) {
            this.record(o, stmt);
        }
        return stmt;
    }

    private void record(BigdataValue describedResource, BigdataStatement stmt) {
        Graph g = this.graphs.get(describedResource);
        if (g == null) {
            g = new GraphImpl();
            this.graphs.put(describedResource, g);
        }
        g.add((Object)stmt);
        if (log.isDebugEnabled()) {
            log.debug((Object)("DESCRIBE: describedResource=" + describedResource + ", statement=" + stmt));
        }
    }

    private void updateCache() {
        for (Map.Entry<BigdataValue, Graph> e : this.graphs.entrySet()) {
            BigdataValue describedResource = e.getKey();
            IV iv = describedResource.getIV();
            if (iv == null) {
                throw new AssertionError((Object)("IV not set: " + describedResource));
            }
            Graph graph = e.getValue();
            this.cache.insert(iv, graph);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("DESCRIBE UPDARTE: describedResource=" + describedResource + ", graph=" + graph));
        }
    }

    public void close() throws QueryEvaluationException {
        if (this.open) {
            this.src.close();
            this.open = false;
        }
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }
}

