/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SolutionSetStats
implements ISolutionSetStats {
    private final long nsolutions;
    private final Set<IVariable<?>> usedVars;
    private final Set<IVariable<?>> notAlwaysBound;
    private final Set<IVariable<?>> alwaysBound;
    private final Set<IVariable<?>> materialized;
    private final Map<IVariable<?>, IConstant<?>> constants;

    public SolutionSetStats(IBindingSet[] bindingSets) {
        if (bindingSets == null) {
            throw new IllegalArgumentException();
        }
        int nsolutions = 0;
        HashSet<IVariable> usedVars = new HashSet<IVariable>();
        HashSet<Object> notAlwaysBound = new HashSet<Object>();
        HashSet<IVariable> notMaterialized = new HashSet<IVariable>();
        HashSet<IVariable> currentVars = new HashSet<IVariable>();
        HashSet<IVariable> notBoundThisSolution = new HashSet<IVariable>();
        for (IBindingSet bset : bindingSets) {
            if (bset == null) {
                throw new IllegalArgumentException();
            }
            ++nsolutions;
            currentVars.clear();
            Iterator vitr = bset.vars();
            while (vitr.hasNext()) {
                IV iv;
                IConstant c;
                IVariable v = (IVariable)vitr.next();
                if (usedVars.add(v) && nsolutions > 1) {
                    notAlwaysBound.add(v);
                }
                currentVars.add(v);
                if (notMaterialized.contains(v) || (c = bset.get(v)) == null || (iv = (IV)c.get()).hasValue()) continue;
                notMaterialized.add(v);
            }
            notBoundThisSolution.clear();
            notBoundThisSolution.addAll(usedVars);
            notBoundThisSolution.removeAll(currentVars);
            notAlwaysBound.addAll(notBoundThisSolution);
        }
        this.nsolutions = nsolutions;
        HashSet alwaysBound = new HashSet(usedVars);
        alwaysBound.removeAll(notAlwaysBound);
        HashSet materialized = new HashSet(usedVars);
        materialized.removeAll(notMaterialized);
        this.usedVars = Collections.unmodifiableSet(usedVars);
        this.alwaysBound = Collections.unmodifiableSet(alwaysBound);
        this.notAlwaysBound = Collections.unmodifiableSet(notAlwaysBound);
        this.materialized = Collections.unmodifiableSet(materialized);
        if (alwaysBound.isEmpty()) {
            this.constants = Collections.emptyMap();
        } else {
            HashMap<IVariable, IConstant> constants = new HashMap<IVariable, IConstant>(alwaysBound.size());
            for (IVariable v : alwaysBound) {
                IConstant firstValue = bindingSets[0].get(v);
                boolean isConstant = true;
                for (int i = 1; i < bindingSets.length; ++i) {
                    IBindingSet bset = bindingSets[i];
                    if (firstValue.equals((IVariableOrConstant)bset.get(v))) continue;
                    isConstant = false;
                    break;
                }
                if (!isConstant) continue;
                constants.put(v, firstValue);
            }
            this.constants = Collections.unmodifiableMap(constants);
        }
    }

    @Override
    public final long getSolutionSetSize() {
        return this.nsolutions;
    }

    @Override
    public final Set<IVariable<?>> getUsedVars() {
        return this.usedVars;
    }

    @Override
    public final Set<IVariable<?>> getAlwaysBound() {
        return this.alwaysBound;
    }

    @Override
    public final Set<IVariable<?>> getNotAlwaysBound() {
        return this.notAlwaysBound;
    }

    @Override
    public final Set<IVariable<?>> getMaterialized() {
        return this.materialized;
    }

    @Override
    public final Map<IVariable<?>, IConstant<?>> getConstants() {
        return this.constants;
    }
}

