/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.lbs.policy.counters;

import com.bigdata.rdf.sail.webapp.lbs.IHostMetrics;
import com.bigdata.rdf.sail.webapp.lbs.IHostScoringRule;

public class DefaultHostScoringRule
implements IHostScoringRule {
    private static final String CPU_NOT_IDLE = "CPU/% Processor Time";
    private static final String CPU_WIO = "CPU/% IO Wait";

    @Override
    public String[] getMetricNames() {
        return new String[]{CPU_NOT_IDLE, CPU_WIO};
    }

    @Override
    public double getScore(IHostMetrics metrics) {
        double cpu_idle = 1.0 - metrics.getNumeric(CPU_NOT_IDLE, 0.5);
        double cpu_wio = metrics.getNumeric(CPU_WIO, 0.05);
        double hostScore = (1.0 + cpu_wio * 100.0) / (1.0 + cpu_idle);
        return hostScore;
    }
}

