/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDDecimalIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.datetime.Timezone;
import org.openrdf.query.algebra.evaluation.function.datetime.Tz;

public class DateBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 9136864442064392445L;

    @Override
    protected boolean areGlobalsRequired() {
        return true;
    }

    public DateBOp(IValueExpression<? extends IV> left, DateOp op, GlobalAnnotations globals) {
        this(new BOp[]{left}, DateBOp.anns(globals, new NV(Annotations.OP, (Object)op)));
    }

    public DateBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null || this.getProperty(Annotations.OP) == null) {
            throw new IllegalArgumentException();
        }
    }

    public DateBOp(DateBOp op) {
        super(op);
    }

    public final IV get(IBindingSet bs) {
        IV left = (IV)this.left().get(bs);
        if (left == null) {
            throw new SparqlTypeErrorException.UnboundVarException();
        }
        if (left.isLiteral()) {
            if (!left.hasValue()) {
                throw new NotMaterializedException();
            }
            BigdataLiteral bl = (BigdataLiteral)left.getValue();
            if (XSD.DATETIME.equals((Object)bl.getDatatype()) || XSD.DATE.equals((Object)bl.getDatatype()) || XSD.TIME.equals((Object)bl.getDatatype())) {
                XMLGregorianCalendar cal = bl.calendarValue();
                switch (this.op()) {
                    case DAY: {
                        return new XSDIntegerIV(BigInteger.valueOf(cal.getDay()));
                    }
                    case MONTH: {
                        return new XSDIntegerIV(BigInteger.valueOf(cal.getMonth()));
                    }
                    case YEAR: {
                        return new XSDIntegerIV(BigInteger.valueOf(cal.getYear()));
                    }
                    case HOURS: {
                        return new XSDIntegerIV(BigInteger.valueOf(cal.getHour()));
                    }
                    case SECONDS: {
                        return new XSDDecimalIV(BigDecimal.valueOf(cal.getSecond()));
                    }
                    case MINUTES: {
                        return new XSDIntegerIV(BigInteger.valueOf(cal.getMinute()));
                    }
                    case TZ: {
                        return this.tz(bl);
                    }
                    case TIMEZONE: {
                        return this.timezone(bl);
                    }
                    case DATE: {
                        Date d = cal.toGregorianCalendar().getTime();
                        String newDate = new SimpleDateFormat("yyyy-MM-dd").format(d);
                        return new FullyInlineTypedLiteralIV(newDate, null, XSD.DATE);
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new SparqlTypeErrorException();
    }

    public IValueExpression<? extends IV> left() {
        return this.get(0);
    }

    public DateOp op() {
        return (DateOp)((Object)this.getRequiredProperty(Annotations.OP));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.op());
        sb.append("(").append(this.left()).append(")");
        return sb.toString();
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    protected IV tz(BigdataLiteral l) {
        Tz func = new Tz();
        BigdataValueFactory vf = super.getValueFactory();
        try {
            BigdataLiteral l2 = (BigdataLiteral)func.evaluate((ValueFactory)vf, new Value[]{l});
            return DummyConstantNode.toDummyIV(l2);
        }
        catch (ValueExprEvaluationException e) {
            throw new SparqlTypeErrorException();
        }
    }

    protected IV timezone(BigdataLiteral l) {
        Timezone func = new Timezone();
        BigdataValueFactory vf = super.getValueFactory();
        try {
            BigdataLiteral l2 = (BigdataLiteral)func.evaluate((ValueFactory)vf, new Value[]{l});
            return DummyConstantNode.toDummyIV(l2);
        }
        catch (ValueExprEvaluationException e) {
            throw new SparqlTypeErrorException();
        }
    }

    public static enum DateOp {
        YEAR,
        MONTH,
        DAY,
        HOURS,
        MINUTES,
        SECONDS,
        TZ,
        TIMEZONE,
        DATE;

    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String OP = (DateBOp.class.getName() + ".op").intern();
    }
}

