/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.htree.data.IDirectoryData;
import com.bigdata.io.AbstractFixedByteArrayBuffer;

public class MutableDirectoryPageData
implements IDirectoryData {
    final byte[] overflowKey;
    final long[] childAddr;
    final boolean hasVersionTimestamps;
    long minimumVersionTimestamp;
    long maximumVersionTimestamp;

    public MutableDirectoryPageData(byte[] overflowKey, int addressBits, boolean hasVersionTimestamps) {
        this.overflowKey = overflowKey;
        this.childAddr = new long[1 << addressBits];
        this.hasVersionTimestamps = hasVersionTimestamps;
        this.maximumVersionTimestamp = 0L;
        this.minimumVersionTimestamp = 0L;
    }

    public MutableDirectoryPageData(int addressBits, IDirectoryData src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.overflowKey = src.getOverflowKey();
        this.childAddr = new long[1 << addressBits];
        this.hasVersionTimestamps = src.hasVersionTimestamps();
        this.copyFrom(src);
    }

    void copyFrom(IDirectoryData src) {
        int nchildren = src.getChildCount();
        for (int i = 0; i < nchildren; ++i) {
            this.childAddr[i] = src.getChildAddr(i);
        }
        if (src.hasVersionTimestamps()) {
            this.minimumVersionTimestamp = src.getMinimumVersionTimestamp();
            this.maximumVersionTimestamp = src.getMaximumVersionTimestamp();
        }
    }

    public MutableDirectoryPageData(byte[] overflowKey, long[] childAddr, boolean hasVersionTimestamps, long minimumVersionTimestamp, long maximumVersionTimestamp) {
        assert (childAddr != null);
        this.overflowKey = overflowKey;
        this.childAddr = childAddr;
        this.hasVersionTimestamps = hasVersionTimestamps;
        this.minimumVersionTimestamp = minimumVersionTimestamp;
        this.maximumVersionTimestamp = maximumVersionTimestamp;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final boolean isCoded() {
        return false;
    }

    @Override
    public final AbstractFixedByteArrayBuffer data() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getChildAddr(int index) {
        return this.childAddr[index];
    }

    @Override
    public final int getChildCount() {
        return this.childAddr.length;
    }

    @Override
    public final boolean isOverflowDirectory() {
        return this.overflowKey != null;
    }

    @Override
    public final boolean isLeaf() {
        return false;
    }

    @Override
    public final boolean hasVersionTimestamps() {
        return this.hasVersionTimestamps;
    }

    @Override
    public final long getMaximumVersionTimestamp() {
        if (!this.hasVersionTimestamps) {
            throw new UnsupportedOperationException();
        }
        return this.maximumVersionTimestamp;
    }

    @Override
    public final long getMinimumVersionTimestamp() {
        if (!this.hasVersionTimestamps) {
            throw new UnsupportedOperationException();
        }
        return this.minimumVersionTimestamp;
    }

    @Override
    public byte[] getOverflowKey() {
        return this.overflowKey;
    }
}

