/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.query;

import com.bigdata.counters.History;
import com.bigdata.counters.HistoryInstrument;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.IHistoryEntry;
import com.bigdata.counters.PeriodEnum;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class HistoryTable {
    protected static final Logger log = Logger.getLogger(HistoryTable.class);
    public final ICounter[] a;
    public final PeriodEnum basePeriod;
    final long[] firstLogicalSlot;
    final long logicalSlotOffset;
    public final long firstTimestamp;
    public final long lastTimestamp;
    final int maxSamplesIndex;
    final int firstSampleTimeIndex;
    final int lastSampleTimeIndex;
    final int maxSamples;
    public final int nrows;
    public final int ncols;
    public final String units;
    public final long period;
    public final IHistoryEntry[][] data;

    public HistoryTable(ICounter[] a, PeriodEnum basePeriod) {
        int col;
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (basePeriod == null) {
            throw new IllegalArgumentException();
        }
        this.a = a;
        this.ncols = a.length;
        this.basePeriod = basePeriod;
        this.units = basePeriod.name();
        this.period = basePeriod.getPeriodMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("#counters=" + a.length + ", units=" + this.units + ", period=" + this.period));
        }
        long firstTimestamp = Long.MAX_VALUE;
        long lastTimestamp = Long.MIN_VALUE;
        int maxSamplesIndex = -1;
        int firstSampleTimeIndex = -1;
        int lastSampleTimeIndex = -1;
        this.firstLogicalSlot = new long[a.length];
        History.SampleIterator[] hitrs = new History.SampleIterator[this.ncols];
        for (col = 0; col < this.ncols; ++col) {
            History.SampleIterator itr;
            if (a[col] == null) {
                throw new IllegalArgumentException();
            }
            if (!(a[col].getInstrument() instanceof HistoryInstrument)) {
                throw new IllegalArgumentException();
            }
            hitrs[col] = itr = ((HistoryInstrument)a[col].getInstrument()).getHistory().iterator();
            int sampleCount = itr.getSampleCount();
            if (sampleCount == 0) continue;
            this.firstLogicalSlot[col] = itr.getFirstSampleTime() / this.period;
            if (itr.getFirstSampleTime() < firstTimestamp) {
                firstTimestamp = itr.getFirstSampleTime();
                firstSampleTimeIndex = col;
            }
            if (itr.getLastSampleTime() > lastTimestamp) {
                lastTimestamp = itr.getLastSampleTime();
                lastSampleTimeIndex = col;
            }
            if (maxSamplesIndex != -1 && sampleCount <= hitrs[maxSamplesIndex].getSampleCount()) continue;
            maxSamplesIndex = col;
        }
        if (maxSamplesIndex != -1) {
            assert (firstSampleTimeIndex != -1);
            assert (lastSampleTimeIndex != -1);
            this.maxSamples = hitrs[maxSamplesIndex].getSampleCount();
            this.maxSamplesIndex = maxSamplesIndex;
            this.firstTimestamp = firstTimestamp;
            this.lastTimestamp = lastTimestamp;
            this.firstSampleTimeIndex = firstSampleTimeIndex;
            this.lastSampleTimeIndex = lastSampleTimeIndex;
            this.logicalSlotOffset = this.firstLogicalSlot[firstSampleTimeIndex];
            int nrows = -1;
            for (int col2 = 0; col2 < this.ncols; ++col2) {
                int x = this.getFirstRowIndex(col2) + hitrs[col2].getSampleCount();
                if (x <= nrows) continue;
                nrows = x;
            }
            this.nrows = nrows;
            if (log.isInfoEnabled()) {
                log.info((Object)("nrows=" + nrows + ", ncols=" + this.ncols));
                log.info((Object)("maxSamples=" + this.maxSamples + " @ index=" + maxSamplesIndex));
                log.info((Object)("firstTimestamp=" + firstTimestamp + " @ index=" + firstSampleTimeIndex));
                log.info((Object)("lastTimestamp=" + lastTimestamp + " @ index=" + lastSampleTimeIndex));
                log.info((Object)("logicalSlotOffset=" + this.logicalSlotOffset + " : firstLogicalSlot=" + Arrays.toString(this.firstLogicalSlot)));
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                for (int i = 0; i < a.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.getFirstRowIndex(i));
                }
                sb.append("]");
                log.info((Object)("adjustedLogicalSlots: " + sb));
            }
        } else {
            this.nrows = 0;
            this.maxSamples = 0;
            this.maxSamplesIndex = 0;
            this.firstTimestamp = 0L;
            this.firstSampleTimeIndex = 0;
            this.lastTimestamp = 0L;
            this.lastSampleTimeIndex = 0;
            this.logicalSlotOffset = 0L;
        }
        this.data = new IHistoryEntry[this.nrows][];
        for (int row = 0; row < this.nrows; ++row) {
            this.data[row] = new IHistoryEntry[this.ncols];
        }
        for (col = 0; col < this.ncols; ++col) {
            int firstRow = this.getFirstRowIndex(col);
            History.SampleIterator itr = hitrs[col];
            int i = 0;
            if (log.isDebugEnabled() && col == 0) {
                log.debug((Object)a[col].getPath());
            }
            while (itr.hasNext()) {
                Object e = itr.next();
                int row = i + firstRow;
                if (log.isDebugEnabled() && col == 0) {
                    log.debug((Object)("data[" + row + "," + col + "] = " + e));
                }
                this.data[row][col] = e;
                ++i;
            }
        }
    }

    public int getFirstRowIndex(int counterIndex) {
        return (int)(this.firstLogicalSlot[counterIndex] - this.logicalSlotOffset);
    }

    public long getTimestamp(int row) {
        return ((long)row + this.logicalSlotOffset) * this.period;
    }
}

