/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.concurrent;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NamedLock<T> {
    private final Map<T, ReentrantLock> locks = new WeakHashMap<T, ReentrantLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock lockFactory(T name) {
        ReentrantLock lock;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Map<T, ReentrantLock> map = this.locks;
        synchronized (map) {
            lock = this.locks.get(name);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(name, lock);
            }
        }
        return lock;
    }

    public Lock acquireLock(T name) {
        Lock lock = this.lockFactory(name);
        lock.lock();
        return lock;
    }

    public Lock acquireLock(T name, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Lock lock = this.lockFactory(name);
        if (!lock.tryLock(timeout, unit)) {
            throw new TimeoutException();
        }
        return lock;
    }
}

