/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba;

import com.bigdata.btree.raba.IRaba;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SubRangeRaba
implements IRaba {
    private final IRaba delegate;
    private final int fromIndex;
    private final int toIndex;
    private final int size;

    public SubRangeRaba(IRaba delegate, int fromIndex, int toIndex) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (toIndex > delegate.size()) {
            throw new IllegalArgumentException();
        }
        if (fromIndex >= toIndex) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isKeys() {
        return this.delegate.isKeys();
    }

    @Override
    public int capacity() {
        return this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isFull() {
        return true;
    }

    private void rangeCheck(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean isNull(int index) {
        this.rangeCheck(index);
        return this.delegate.isNull(index + this.fromIndex);
    }

    @Override
    public int length(int index) {
        this.rangeCheck(index);
        return this.delegate.length(index + this.fromIndex);
    }

    @Override
    public byte[] get(int index) {
        this.rangeCheck(index);
        return this.delegate.get(index + this.fromIndex);
    }

    @Override
    public int copy(int index, OutputStream os) {
        this.rangeCheck(index);
        return this.delegate.copy(index + this.fromIndex, os);
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            private int i;
            {
                this.i = SubRangeRaba.this.fromIndex;
            }

            @Override
            public boolean hasNext() {
                return this.i < SubRangeRaba.this.toIndex;
            }

            @Override
            public byte[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SubRangeRaba.this.delegate.get(this.i++);
            }

            @Override
            public void remove() {
                if (SubRangeRaba.this.isReadOnly()) {
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void set(int index, byte[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int add(byte[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int add(byte[] value, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int add(DataInput in, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int search(byte[] searchKey) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getName() + "{fromIndex=" + this.fromIndex + ",toIndex=" + this.toIndex + ",size=" + this.size + ",delegate=" + this.delegate + "}";
    }
}

